/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc.apiclient;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.component.webrtc.apiclient.FilePathInput;
import org.teamapps.ux.component.webrtc.apiclient.KindsByFileInput;
import org.teamapps.ux.component.webrtc.apiclient.KindsOptionsData;
import org.teamapps.ux.component.webrtc.apiclient.ListData;
import org.teamapps.ux.component.webrtc.apiclient.MediaKind;
import org.teamapps.ux.component.webrtc.apiclient.MediaSoupV3ApiClient;
import org.teamapps.ux.component.webrtc.apiclient.MediaSoupV3TokenGenerator;
import org.teamapps.ux.component.webrtc.apiclient.NumWorkersData;
import org.teamapps.ux.component.webrtc.apiclient.StatsInput;
import org.teamapps.ux.component.webrtc.apiclient.StreamAndKinds;
import org.teamapps.ux.component.webrtc.apiclient.StreamData;
import org.teamapps.ux.component.webrtc.apiclient.StreamFileRequest;
import org.teamapps.ux.component.webrtc.apiclient.WorkerLoadData;

public class MediaSoupV3RestClient
implements MediaSoupV3ApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final WebTarget webTarget;
    private final String serverSecret;

    public MediaSoupV3RestClient(String serverUrl, String serverSecret) {
        this.webTarget = ClientBuilder.newClient().target(serverUrl).path("api");
        this.serverSecret = serverSecret;
    }

    @Override
    public CompletableFuture<Void> startFileStreaming(int workerId, StreamFileRequest streamFileRequest) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.webTarget.path(workerId + "/fileStreaming").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateStreamingJwtToken(streamFileRequest.getStreamUuid(), this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)streamFileRequest, (String)"application/json"), (InvocationCallback)new InvocationCallback<Void>(){

            public void completed(Void s) {
                future.complete(s);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> stopFileStreaming(int workerId, String streamUuid) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.webTarget.path(workerId + "/stopFileStreaming").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateStreamingJwtToken(streamUuid, this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)new StreamData(streamUuid), (String)"application/json"), (InvocationCallback)new InvocationCallback<Void>(){

            public void completed(Void s) {
                future.complete(s);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> startRecording(String streamUuid) {
        return this.startRecording(streamUuid, null);
    }

    @Override
    public CompletableFuture<Void> startRecording(String streamUuid, Set<MediaKind> kinds) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.webTarget.path("0/startRecording").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)new StreamAndKinds(streamUuid, kinds), (String)"application/json"), (InvocationCallback)new InvocationCallback<Void>(){

            public void completed(Void s) {
                future.complete(s);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> stopRecording(String streamUuid) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.webTarget.path("0/stopRecording").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)new StreamAndKinds(streamUuid, Set.of(MediaKind.AUDIO, MediaKind.VIDEO)), (String)"application/json"), (InvocationCallback)new InvocationCallback<Void>(){

            public void completed(Void s) {
                future.complete(s);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    public CompletableFuture<JsonNode> transportStats(List<String> ids) {
        final CompletableFuture<JsonNode> future = new CompletableFuture<JsonNode>();
        this.webTarget.path("0/transportStats").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)new StatsInput(ids), (String)"application/json"), (InvocationCallback)new InvocationCallback<JsonNode>(){

            public void completed(JsonNode s) {
                future.complete(s);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Double> getWorkerLoad(int workerId) {
        final CompletableFuture<Double> future = new CompletableFuture<Double>();
        this.webTarget.path("0/workerLoad").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity(null, (String)"application/json"), (InvocationCallback)new InvocationCallback<WorkerLoadData>(){

            public void completed(WorkerLoadData s) {
                future.complete(s.getCurrentLoad());
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Integer> getNumberOfWorkers() {
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.webTarget.path("0/numWorkers").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity(null, (String)"application/json"), (InvocationCallback)new InvocationCallback<NumWorkersData>(){

            public void completed(NumWorkersData s) {
                future.complete(s.getNum());
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<String>> getRecordedStreamUuids() {
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.webTarget.path("0/recordedStreams").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity(null, (String)"application/json"), (InvocationCallback)new InvocationCallback<ListData>(){

            public void completed(ListData s) {
                future.complete(s.getList());
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<String>> getStreamRecordingsForUuid(String streamUuid) {
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.webTarget.path("0/streamRecordings").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)new StreamData(streamUuid), (String)"application/json"), (InvocationCallback)new InvocationCallback<ListData>(){

            public void completed(ListData s) {
                future.complete(s.getList());
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteStreamRecordings(String streamUuid) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.webTarget.path("0/deleteStreamRecordings").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)new StreamData(streamUuid), (String)"application/json"), (InvocationCallback)new InvocationCallback<Void>(){

            public void completed(Void s) {
                future.complete(s);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteRecording(String filePathInput) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.webTarget.path("0/deleteRecording").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)new FilePathInput(filePathInput), (String)"application/json"), (InvocationCallback)new InvocationCallback<Void>(){

            public void completed(Void s) {
                future.complete(s);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    public CompletableFuture<KindsOptionsData> kindsByFile(String filePath, boolean relativePath) {
        final CompletableFuture<KindsOptionsData> future = new CompletableFuture<KindsOptionsData>();
        this.webTarget.path("0/kindsByFile").request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L)))).async().post(Entity.entity((Object)new KindsByFileInput(filePath, relativePath), (String)"application/json"), (InvocationCallback)new InvocationCallback<KindsOptionsData>(){

            public void completed(KindsOptionsData s) {
                future.complete(s);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }
}

