/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.assembler;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.ResponsiveApplicationToolbar;
import org.teamapps.ux.application.assembler.ApplicationAssembler;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.workspacelayout.ViewGroupPanelState;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutView;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutViewGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;

public class DesktopApplicationAssembler
implements ApplicationAssembler {
    private static Logger LOGGER = LoggerFactory.getLogger(DesktopApplicationAssembler.class);
    private ResponsiveApplicationToolbar responsiveApplicationToolbar;
    private WorkSpaceLayout workSpaceLayout = new WorkSpaceLayout();
    private LayoutItemDefinition currentLayout;

    public void addView(View view) {
        String layoutPosition = view.getLayoutPosition();
        WorkSpaceLayoutViewGroup viewGroup = this.workSpaceLayout.getViewGroupById(layoutPosition);
        if (viewGroup == null) {
            LOGGER.error("Cannot find viewGroup for layout position " + layoutPosition);
            return;
        }
        WorkSpaceLayoutView layoutView = new WorkSpaceLayoutView(this.workSpaceLayout, view.getPanel(), view.getPanel().getTitle(), true, false);
        viewGroup.addView(layoutView);
        if (viewGroup != null && viewGroup.getPanelState() != ViewGroupPanelState.NORMAL) {
            viewGroup.setPanelState(ViewGroupPanelState.NORMAL);
        }
    }

    public boolean isViewAttached(View view) {
        String layoutPosition = view.getLayoutPosition();
        WorkSpaceLayoutViewGroup viewGroup = this.workSpaceLayout.getViewGroupById(layoutPosition);
        if (viewGroup == null) {
            return false;
        }
        for (WorkSpaceLayoutView layoutView : viewGroup.getViews()) {
            if (!view.getPanel().equals(layoutView.getPanel())) continue;
            return true;
        }
        return false;
    }

    public void removeView(View view) {
        WorkSpaceLayoutView layoutView = this.workSpaceLayout.getViewByPanel(view.getPanel());
        if (layoutView != null) {
            layoutView.remove();
        }
    }

    @Override
    public void setWorkSpaceToolbar(ResponsiveApplicationToolbar responsiveApplicationToolbar) {
        this.responsiveApplicationToolbar = responsiveApplicationToolbar;
        this.workSpaceLayout.setToolbar(responsiveApplicationToolbar.getToolbar());
    }

    @Override
    public Component createApplication(ResponsiveApplication application) {
        return this.workSpaceLayout;
    }

    @Override
    public void handleApplicationViewAdded(ResponsiveApplication application, View view) {
        this.addView(view);
    }

    @Override
    public void handleApplicationViewRemoved(ResponsiveApplication application, View view) {
        this.removeView(view);
    }

    @Override
    public void handlePerspectiveChange(ResponsiveApplication application, Perspective perspective, Perspective previousPerspective, List<View> activeViews, List<View> addedViews, List<View> removedViews) {
        if (this.currentLayout == null || !perspective.getLayout().equals(this.currentLayout)) {
            this.currentLayout = perspective.getLayout();
            this.workSpaceLayout.applyLayoutDefinition(this.currentLayout);
        }
        removedViews.forEach(view -> this.removeView((View)view));
        addedViews.forEach(view -> this.addView((View)view));
        application.getApplicationViews().forEach(view -> {
            if (!this.isViewAttached((View)view)) {
                this.addView((View)view);
            }
        });
    }

    @Override
    public void handleLayoutChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, LayoutItemDefinition layout) {
        if (isActivePerspective) {
            this.currentLayout = layout;
            this.workSpaceLayout.applyLayoutDefinition(layout);
        }
    }

    @Override
    public void handleViewAdded(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            this.addView(view);
        }
    }

    @Override
    public void handleViewRemoved(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view) {
        if (isActivePerspective) {
            this.removeView(view);
        }
    }

    @Override
    public void handleViewVisibilityChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean visible) {
        if (isActivePerspective) {
            if (visible) {
                this.addView(view);
            } else {
                this.removeView(view);
            }
        }
    }

    @Override
    public void handleViewFocusRequest(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, boolean ensureVisible) {
        if (!isActivePerspective || ensureVisible) {
            // empty if block
        }
    }

    @Override
    public void handleViewSizeChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, ViewSize viewSize) {
        WorkSpaceLayoutView layoutView;
        if (isActivePerspective && viewSize != null && (layoutView = this.workSpaceLayout.getViewByPanel(view.getPanel())) != null) {
            if (viewSize.isWidthAvailable()) {
                if (viewSize.getRelativeWidth() != null) {
                    layoutView.setRelativeWidth(viewSize.getRelativeWidth().floatValue());
                } else {
                    layoutView.setAbsoluteWidth(viewSize.getAbsoluteWidth());
                }
            }
            if (viewSize.isHeightAvailable()) {
                if (viewSize.getRelativeHeight() != null) {
                    layoutView.setRelativeHeight(viewSize.getRelativeHeight().floatValue());
                } else {
                    layoutView.setAbsoluteHeight(viewSize.getAbsoluteHeight());
                }
            }
        }
    }

    @Override
    public void handleViewLayoutPositionChange(ResponsiveApplication application, boolean isActivePerspective, Perspective perspective, View view, String position) {
        if (isActivePerspective) {
            WorkSpaceLayoutView layoutView = this.workSpaceLayout.getViewByPanel(view.getPanel());
            layoutView.remove();
            this.addView(view);
        }
    }
}

