/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiLineChartLineFormat;
import org.teamapps.dto.UiLongInterval;
import org.teamapps.dto.UiTimeChartZoomLevel;
import org.teamapps.dto.UiTimeGraph;
import org.teamapps.dto.UiTimeGraphDataPoint;
import org.teamapps.event.Event;
import org.teamapps.event.EventListener;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartDataPoint;
import org.teamapps.ux.component.timegraph.LineChartLine;
import org.teamapps.ux.component.timegraph.LineChartLineListener;
import org.teamapps.ux.component.timegraph.LineChartMouseScrollZoomPanMode;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.TimeGraphZoomLevel;
import org.teamapps.ux.component.timegraph.ZoomEventData;

public class TimeGraph
extends AbstractComponent {
    public final Event<ZoomEventData> onZoomed = new Event();
    public final Event<Interval> onIntervalSelected = new Event();
    private final List<LineChartLine> lines = new ArrayList<LineChartLine>();
    private int maxPixelsBetweenDataPoints = 50;
    private TimeGraphModel model;
    private LineChartMouseScrollZoomPanMode mouseScrollZoomPanMode = LineChartMouseScrollZoomPanMode.ENABLED;
    private Interval selectedInterval;
    private Supplier<EagerFetchingParameters> eagerFetchingParametersSupplier;
    private final EventListener<Void> onTimeGraphDataChangedListener = this::onTimeGraphDataChanged;

    public TimeGraph(TimeGraphModel model) {
        this.model = model;
        this.setModel(model);
    }

    public void addLine(String lineId, LineChartCurveType graphType, float dataDotRadius, Color lineColor, Color areaColor) {
        this.addLine(new LineChartLine(lineId, graphType, dataDotRadius, lineColor, areaColor));
    }

    public void addLine(LineChartLine lineFormat) {
        this.lines.add(lineFormat);
        this.setLines(new ArrayList<LineChartLine>(this.lines));
    }

    public void setLines(List<LineChartLine> lineFormats) {
        this.lines.clear();
        lineFormats.forEach(line -> {
            this.lines.add((LineChartLine)line);
            line.setChangeListener(new LineChartLineListener((LineChartLine)line){
                final /* synthetic */ LineChartLine val$line;
                {
                    this.val$line = lineChartLine;
                }

                @Override
                public void handleGraphTypeChanged(LineChartLine lineChartLine, LineChartCurveType graphType) {
                    TimeGraph.this.reRenderIfRendered();
                }

                @Override
                public void handleDataDotRadiusChanged(LineChartLine lineChartLine, float dataDotRadius) {
                    TimeGraph.this.reRenderIfRendered();
                }

                @Override
                public void handleLineColorScaleMinChanged(LineChartLine lineChartLine, Color lineColorScaleMin) {
                    TimeGraph.this.reRenderIfRendered();
                }

                @Override
                public void handleLineColorScaleMaxChanged(LineChartLine lineChartLine, Color lineColorScaleMax) {
                    TimeGraph.this.reRenderIfRendered();
                }

                @Override
                public void handleAreaColorScaleMinChanged(LineChartLine lineChartLine, Color areaColorScaleMin) {
                    TimeGraph.this.reRenderIfRendered();
                }

                @Override
                public void handleAreaColorScaleMaxChanged(LineChartLine lineChartLine, Color areaColorScaleMax) {
                    TimeGraph.this.reRenderIfRendered();
                }

                @Override
                public void handleIntervalYChanged(LineChartLine lineChartLine, Interval intervalY) {
                    TimeGraph.this.queueCommandIfRendered(() -> new UiTimeGraph.SetIntervalYCommand(TimeGraph.this.getId(), this.val$line.getId(), intervalY.createUiLongInterval()));
                }

                @Override
                public void handleYScaleTypeChanged(LineChartLine lineChartLine, ScaleType yScaleType) {
                    TimeGraph.this.queueCommandIfRendered(() -> new UiTimeGraph.SetYScaleTypeCommand(TimeGraph.this.getId(), this.val$line.getId(), yScaleType.toUiScaleType()));
                }

                @Override
                public void handleYScaleZoomModeChanged(LineChartLine lineChartLine, LineChartYScaleZoomMode yScaleZoomMode) {
                    TimeGraph.this.queueCommandIfRendered(() -> new UiTimeGraph.SetYScaleZoomModeCommand(TimeGraph.this.getId(), this.val$line.getId(), yScaleZoomMode.toUiLineChartYScaleZoomMode()));
                }

                @Override
                public void handleYAxisColorChanged(LineChartLine lineChartLine, Color yAxisColor) {
                    TimeGraph.this.reRenderIfRendered();
                }
            });
        });
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetLineFormatsCommand(this.getId(), this.toUiLineFormats(lineFormats)));
        this.refresh();
    }

    private Map<String, UiLineChartLineFormat> toUiLineFormats(List<LineChartLine> lineFormats) {
        return lineFormats.stream().collect(Collectors.toMap(lf -> lf.getId(), lf -> lf.createUiLineChartLineFormat()));
    }

    public List<String> getLineIds() {
        return this.lines.stream().map(LineChartLine::getId).collect(Collectors.toList());
    }

    @Override
    public UiComponent createUiComponent() {
        List<UiTimeChartZoomLevel> uiZoomLevels = this.createUiZoomlevels();
        Map<String, UiLineChartLineFormat> uiLineFormats = this.toUiLineFormats(this.lines);
        Interval domainX = this.model.getDomainX(this.getLineIds());
        UiLongInterval uiIntervalX = new Interval(domainX.getMin(), domainX.getMax()).createUiLongInterval();
        UiTimeGraph uiTimeGraph = new UiTimeGraph(this.getId(), uiIntervalX, uiZoomLevels, this.maxPixelsBetweenDataPoints, uiLineFormats);
        this.mapAbstractUiComponentProperties((UiComponent)uiTimeGraph);
        uiTimeGraph.setMouseScrollZoomPanMode(this.mouseScrollZoomPanMode.toUiLineChartMouseScrollZoomPanMode());
        return uiTimeGraph;
    }

    @NotNull
    private List<UiTimeChartZoomLevel> createUiZoomlevels() {
        return this.model.getZoomLevels().stream().map(TimeGraphZoomLevel::createUiTimeChartZoomLevel).collect(Collectors.toList());
    }

    @Override
    protected void doDestroy() {
        this.unregisterModelListeners();
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TIME_GRAPH_DATA_NEEDED: {
                UiTimeGraph.DataNeededEvent dataNeededEvent = (UiTimeGraph.DataNeededEvent)event;
                Interval interval = new Interval(dataNeededEvent.getNeededIntervalX().getMin(), dataNeededEvent.getNeededIntervalX().getMax());
                TimeGraphZoomLevel zoomLevel = this.model.getZoomLevels().get(dataNeededEvent.getZoomLevelIndex());
                Map<String, List<LineChartDataPoint>> data = this.model.getDataPoints(this.getLineIds(), zoomLevel, interval);
                this.queueCommandIfRendered(() -> new UiTimeGraph.AddDataCommand(this.getId(), dataNeededEvent.getZoomLevelIndex(), dataNeededEvent.getNeededIntervalX(), this.convertToUiData(data)));
                break;
            }
            case UI_TIME_GRAPH_ZOOMED: {
                UiTimeGraph.ZoomedEvent zoomedEvent = (UiTimeGraph.ZoomedEvent)event;
                Interval interval = new Interval(zoomedEvent.getIntervalX().getMin(), zoomedEvent.getIntervalX().getMax());
                this.onZoomed.fire(new ZoomEventData(interval, zoomedEvent.getZoomLevelIndex()));
                break;
            }
            case UI_TIME_GRAPH_INTERVAL_SELECTED: {
                Interval interval;
                UiTimeGraph.IntervalSelectedEvent selectedEvent = (UiTimeGraph.IntervalSelectedEvent)event;
                this.selectedInterval = interval = selectedEvent.getIntervalX() != null ? new Interval(selectedEvent.getIntervalX().getMin(), selectedEvent.getIntervalX().getMax()) : null;
                this.onIntervalSelected.fire(interval);
                break;
            }
        }
    }

    private Map<String, List<UiTimeGraphDataPoint>> convertToUiData(Map<String, List<LineChartDataPoint>> data) {
        HashMap<String, List<UiTimeGraphDataPoint>> uiData = new HashMap<String, List<UiTimeGraphDataPoint>>();
        data.forEach((lineId, dataPoints) -> uiData.put((String)lineId, dataPoints.stream().map(dataPoint -> new UiTimeGraphDataPoint(dataPoint.getX(), dataPoint.getY())).collect(Collectors.toList())));
        return uiData;
    }

    public void refresh() {
        if (this.eagerFetchingParametersSupplier != null) {
            this.queueCommandIfRendered(() -> {
                EagerFetchingParameters eagerFetchingConfig = this.eagerFetchingParametersSupplier.get();
                TimeGraphZoomLevel zoomLevel = this.model.getZoomLevels().get(eagerFetchingConfig.zoomLevelIndex);
                Map<String, List<UiTimeGraphDataPoint>> uiData = this.convertToUiData(this.model.getDataPoints(this.getLineIds(), zoomLevel, eagerFetchingConfig.intervalX));
                return new UiTimeGraph.ReplaceAllDataCommand(this.getId(), this.createUiZoomlevels(), eagerFetchingConfig.zoomLevelIndex, eagerFetchingConfig.intervalX.createUiLongInterval(), uiData);
            });
        } else {
            this.queueCommandIfRendered(() -> new UiTimeGraph.ResetAllDataCommand(this.getId(), this.createUiZoomlevels()));
        }
    }

    public int getMaxPixelsBetweenDataPoints() {
        return this.maxPixelsBetweenDataPoints;
    }

    public void setMaxPixelsBetweenDataPoints(int maxPixelsBetweenDataPoints) {
        this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetMaxPixelsBetweenDataPointsCommand(this.getId(), maxPixelsBetweenDataPoints));
    }

    public LineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
        return this.mouseScrollZoomPanMode;
    }

    public void setMouseScrollZoomPanMode(LineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
        this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetMouseScrollZoomPanModeCommand(this.getId(), mouseScrollZoomPanMode.toUiLineChartMouseScrollZoomPanMode()));
    }

    public Interval getSelectedInterval() {
        return this.selectedInterval;
    }

    public void setSelectedInterval(Interval selectedInterval) {
        this.selectedInterval = selectedInterval;
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetSelectedIntervalCommand(this.getId(), selectedInterval.createUiLongInterval()));
    }

    public void setModel(TimeGraphModel model) {
        this.unregisterModelListeners();
        if (model != null) {
            model.onDataChanged().addListener(this.onTimeGraphDataChangedListener);
        }
        this.model = model;
        this.refresh();
    }

    private void unregisterModelListeners() {
        if (this.model != null) {
            this.model.onDataChanged().removeListener(this.onTimeGraphDataChangedListener);
        }
    }

    private void onTimeGraphDataChanged(Void aVoid) {
        Interval domainX = this.model.getDomainX(this.getLineIds());
        UiLongInterval uiIntervalX = new Interval(domainX.getMin(), domainX.getMax()).createUiLongInterval();
        this.queueCommandIfRendered(() -> new UiTimeGraph.SetIntervalXCommand(this.getId(), uiIntervalX));
        this.refresh();
    }

    public void setEagerFetchingParametersSupplier(Supplier<EagerFetchingParameters> eagerFetchingParameterSupplier) {
        this.eagerFetchingParametersSupplier = eagerFetchingParameterSupplier;
    }

    public Supplier<EagerFetchingParameters> getEagerFetchingParametersSupplier() {
        return this.eagerFetchingParametersSupplier;
    }

    public static class EagerFetchingParameters {
        private final int zoomLevelIndex;
        private final Interval intervalX;

        public EagerFetchingParameters(int zoomLevelIndex, Interval intervalX) {
            this.zoomLevelIndex = zoomLevelIndex;
            this.intervalX = intervalX;
        }

        public int getZoomLevelIndex() {
            return this.zoomLevelIndex;
        }

        public Interval getIntervalX() {
            return this.intervalX;
        }
    }
}

