/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.function.Supplier;
import org.teamapps.ux.application.Application;
import org.teamapps.ux.application.ApplicationDesktop;
import org.teamapps.ux.application.ApplicationInfo;

public interface ApplicationBuilder {
    public static ApplicationBuilder create(final Supplier<Application> applicationSupplier, final ApplicationInfo applicationInfo) {
        return new ApplicationBuilder(){

            @Override
            public ApplicationInfo getApplicationInfo() {
                return applicationInfo;
            }

            @Override
            public Application createApplication(ApplicationDesktop applicationDesktop) {
                return (Application)applicationSupplier.get();
            }
        };
    }

    public static ApplicationBuilder create(final Supplier<Application> applicationSupplier, final ApplicationInfo applicationInfo, final Supplier<Boolean> accessDecider) {
        return new ApplicationBuilder(){

            @Override
            public ApplicationInfo getApplicationInfo() {
                return applicationInfo;
            }

            @Override
            public Application createApplication(ApplicationDesktop applicationDesktop) {
                return (Application)applicationSupplier.get();
            }

            @Override
            public boolean isApplicationAccessible() {
                return (Boolean)accessDecider.get();
            }
        };
    }

    default public boolean isApplicationAccessible() {
        return true;
    }

    public ApplicationInfo getApplicationInfo();

    public Application createApplication(ApplicationDesktop var1);
}

