/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.mobile;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiNavigationBar;
import org.teamapps.dto.UiNavigationBarButton;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.mobile.NavigationBarButton;
import org.teamapps.ux.component.progress.DefaultMultiProgressDisplay;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class NavigationBar<RECORD>
extends AbstractComponent
implements Container {
    public Event<NavigationBarButton> onButtonClick = new Event();
    private Template buttonTemplate = BaseTemplate.NAVIGATION_BAR_ICON_ONLY;
    private List<NavigationBarButton<RECORD>> buttons = new ArrayList<NavigationBarButton<RECORD>>();
    private Color backgroundColor;
    private Color borderColor;
    private final List<Component> fanOutComponents = new ArrayList<Component>();
    private Component activeFanOutComponent;
    private int buttonClientIdCounter = 0;
    private MultiProgressDisplay multiProgressDisplay = new DefaultMultiProgressDisplay();

    @Override
    public UiComponent createUiComponent() {
        UiNavigationBar uiNavigationBar = new UiNavigationBar(this.buttonTemplate.createUiTemplate());
        this.mapAbstractUiComponentProperties((UiComponent)uiNavigationBar);
        uiNavigationBar.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        uiNavigationBar.setBorderColor(this.borderColor != null ? this.borderColor.toHtmlColorString() : null);
        if (this.buttons != null) {
            List<UiNavigationBarButton> uiNavigationBarButtons = this.createUiButtons();
            uiNavigationBar.setButtons(uiNavigationBarButtons);
        }
        if (this.fanOutComponents != null) {
            List uiComponents = this.fanOutComponents.stream().map(component -> component.createUiReference()).collect(Collectors.toList());
            uiNavigationBar.setFanOutComponents(uiComponents);
        }
        uiNavigationBar.setMultiProgressDisplay(this.multiProgressDisplay.createUiReference());
        return uiNavigationBar;
    }

    private List<UiNavigationBarButton> createUiButtons() {
        return this.buttons.stream().map(navigationBarButton -> navigationBarButton.createUiNavigationBarButton()).collect(Collectors.toList());
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_NAVIGATION_BAR_BUTTON_CLICKED: {
                UiNavigationBar.ButtonClickedEvent clickedEvent = (UiNavigationBar.ButtonClickedEvent)event;
                String buttonId = clickedEvent.getButtonId();
                this.buttons.stream().filter(btn -> btn.getClientId().equals(buttonId)).forEach(button -> {
                    this.onButtonClick.fire((NavigationBarButton)button);
                    button.onClick.fire(null);
                });
                break;
            }
            case UI_NAVIGATION_BAR_FANOUT_CLOSED_DUE_TO_CLICK_OUTSIDE_FANOUT: {
                this.activeFanOutComponent = null;
            }
        }
    }

    public NavigationBar<RECORD> addButton(NavigationBarButton<RECORD> button) {
        return this.addButton(button, false);
    }

    public NavigationBar<RECORD> addButton(NavigationBarButton<RECORD> button, boolean left) {
        button.setClientId("" + ++this.buttonClientIdCounter);
        button.setContainer(this);
        if (left) {
            this.buttons.add(0, button);
        } else {
            this.buttons.add(button);
        }
        this.queueCommandIfRendered(() -> new UiNavigationBar.SetButtonsCommand(this.getId(), this.createUiButtons()));
        return this;
    }

    void handleButtonVisibilityChanged(NavigationBarButton<RECORD> button) {
        this.queueCommandIfRendered(() -> new UiNavigationBar.SetButtonVisibleCommand(this.getId(), button.getClientId(), button.isVisible()));
    }

    public void removeButton(NavigationBarButton<RECORD> button) {
        this.buttons.remove(button);
        this.queueCommandIfRendered(() -> new UiNavigationBar.SetButtonsCommand(this.getId(), this.createUiButtons()));
    }

    public void preloadFanOutComponent(Component component) {
        this.fanOutComponents.add(component);
        component.setParent(this);
        this.queueCommandIfRendered(() -> new UiNavigationBar.AddFanOutComponentCommand(this.getId(), component.createUiReference()));
    }

    public void showFanOutComponent(Component component) {
        if (!this.fanOutComponents.contains(component)) {
            this.preloadFanOutComponent(component);
        }
        this.activeFanOutComponent = component;
        this.queueCommandIfRendered(() -> new UiNavigationBar.ShowFanOutComponentCommand(this.getId(), component.createUiReference()));
    }

    public void hideFanOutComponent() {
        if (this.activeFanOutComponent == null) {
            return;
        }
        this.activeFanOutComponent = null;
        this.queueCommandIfRendered(() -> new UiNavigationBar.HideFanOutComponentCommand(this.getId()));
    }

    public void showOrHideFanoutComponent(Component component) {
        if (this.activeFanOutComponent == component) {
            this.hideFanOutComponent();
        } else {
            this.showFanOutComponent(component);
        }
    }

    public Template getButtonTemplate() {
        return this.buttonTemplate;
    }

    public void setButtonTemplate(Template buttonTemplate) {
        this.buttonTemplate = buttonTemplate;
    }

    public List<NavigationBarButton<RECORD>> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<NavigationBarButton<RECORD>> buttons) {
        buttons.forEach(button -> button.setContainer(this));
        this.buttons = buttons;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.queueCommandIfRendered(() -> new UiNavigationBar.SetBackgroundColorCommand(this.getId(), backgroundColor != null ? backgroundColor.toHtmlColorString() : null));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.queueCommandIfRendered(() -> new UiNavigationBar.SetBorderColorCommand(this.getId(), borderColor != null ? borderColor.toHtmlColorString() : null));
    }

    public List<Component> getFanOutComponents() {
        return this.fanOutComponents;
    }

    public Component getActiveFanOutComponent() {
        return this.activeFanOutComponent;
    }

    @Override
    public boolean isChildVisible(Component child) {
        return this.isEffectivelyVisible() && this.activeFanOutComponent == child;
    }

    public void setMultiProgressDisplay(MultiProgressDisplay multiProgressDisplay) {
        this.multiProgressDisplay = multiProgressDisplay;
        this.queueCommandIfRendered(() -> new UiNavigationBar.SetMultiProgressDisplayCommand(this.getId(), multiProgressDisplay.createUiReference()));
    }

    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.multiProgressDisplay;
    }
}

