/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.extract;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.ClassAndPropertyName;
import org.teamapps.data.extract.PropertyInjector;
import org.teamapps.data.extract.ValueInjector;
import org.teamapps.util.ReflectionUtil;

public class BeanPropertyInjector<RECORD>
implements PropertyInjector<RECORD> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanPropertyInjector.class);
    private static final Map<ClassAndPropertyName, ValueInjector> settersByClassAndPropertyName = new ConcurrentHashMap<ClassAndPropertyName, ValueInjector>();
    private final Map<String, ValueInjector> customInjectors = new HashMap<String, ValueInjector>(0);

    @Override
    public void setValue(RECORD record, String propertyName, Object value) {
        ValueInjector valueInjector = this.getValueInjector(record.getClass(), propertyName);
        valueInjector.inject(record, value);
    }

    private ValueInjector getValueInjector(Class clazz, String propertyName) {
        ValueInjector ValueInjector2 = this.customInjectors.get(propertyName);
        if (ValueInjector2 != null) {
            return ValueInjector2;
        }
        return settersByClassAndPropertyName.computeIfAbsent(new ClassAndPropertyName(clazz, propertyName), classAndPropertyName -> this.createValueInjector((ClassAndPropertyName)classAndPropertyName));
    }

    private ValueInjector<RECORD, ?> createValueInjector(ClassAndPropertyName classAndPropertyName) {
        Method setter = ReflectionUtil.findSetter(classAndPropertyName.clazz, classAndPropertyName.propertyName);
        return (record, value) -> {
            if (setter != null) {
                ReflectionUtil.invokeMethod(record, setter, value);
            } else {
                LOGGER.debug("Could not find setter for property {} on class {}!", (Object)classAndPropertyName.propertyName, (Object)record.getClass().getCanonicalName());
            }
        };
    }

    public <VALUE> BeanPropertyInjector<RECORD> addProperty(String propertyName, ValueInjector<RECORD, VALUE> valueInjector) {
        this.customInjectors.put(propertyName, valueInjector);
        return this;
    }
}

