/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiRootPanel;
import org.teamapps.event.Event;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.format.Shadow;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.css.CssStyles;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public abstract class AbstractComponent
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractComponent.class);
    public final Event<Void> onRendered = new Event();
    private String debuggingId = "";
    private final String id;
    private final SessionContext sessionContext;
    private RenderingState renderingState = RenderingState.NOT_RENDERED;
    private Container container;
    private boolean visible = true;
    private final Map<String, CssStyles> stylesBySelector = new HashMap<String, CssStyles>(0);

    public AbstractComponent() {
        this.sessionContext = CurrentSessionContext.get();
        this.id = this.getClass().getSimpleName() + "-" + UUID.randomUUID().toString();
    }

    protected void mapAbstractUiComponentProperties(UiComponent uiComponent) {
        uiComponent.setId(this.id);
        uiComponent.setDebuggingId(this.debuggingId);
        uiComponent.setVisible(this.visible);
        uiComponent.setStylesBySelector(this.stylesBySelector);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public boolean isRendered() {
        return this.renderingState == RenderingState.RENDERED;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        boolean changed = visible != this.visible;
        this.visible = visible;
        if (changed) {
            this.queueCommandIfRendered(() -> new UiComponent.SetVisibleCommand(this.getId(), visible));
        }
    }

    @Override
    public boolean isEffectivelyVisible() {
        return this.isRendered() && this.isVisible() && this.getParent() != null && this.getParent().isChildVisible(this);
    }

    @Override
    public final void render() {
        if (this.renderingState == RenderingState.RENDERED) {
            return;
        }
        if (!(this instanceof RootPanel) && this.getParent() == null) {
            LOGGER.debug("Rendering component (" + this.getClass().getSimpleName() + ") that has no parent set. This is a temporary logging message to be able to find Containers that do not register themselves as \"parent\" of their children.");
        }
        LOGGER.debug("render: " + this.getId());
        this.sessionContext.registerClientObject(this);
        this.renderingState = RenderingState.RENDERING;
        UiComponent uiComponent = this.createUiComponent();
        this.sessionContext.queueCommand(new UiRootPanel.CreateComponentCommand(uiComponent));
        this.renderingState = RenderingState.RENDERED;
        this.onRendered.fire(null);
    }

    @Override
    public final void unrender() {
        this.sessionContext.unregisterClientObject(this);
        this.sessionContext.queueCommand(new UiRootPanel.DestroyComponentCommand(this.getId()));
        this.renderingState = RenderingState.NOT_RENDERED;
    }

    public abstract UiComponent createUiComponent();

    @Override
    public UiClientObjectReference createUiReference() {
        LOGGER.debug("createUiClientObjectReference: " + this.getId());
        if (!this.isRendered()) {
            this.render();
        }
        return new UiClientObjectReference(this.getId());
    }

    public void reRenderIfRendered() {
        if (this.renderingState == RenderingState.RENDERED) {
            this.sessionContext.queueCommand(new UiRootPanel.RefreshComponentCommand(this.createUiComponent()));
        }
    }

    protected void queueCommandIfRendered(Supplier<UiCommand<?>> commandSupplier) {
        if (this.renderingState == RenderingState.RENDERED) {
            this.sessionContext.queueCommand(commandSupplier.get());
        } else if (this.renderingState == RenderingState.RENDERING) {
            this.sessionContext.runWithContext(() -> this.sessionContext.queueCommand((UiCommand)commandSupplier.get()), true);
        }
    }

    @Override
    public void setMinWidth(Length minWidth) {
        this.setCssStyle("min-width", minWidth.toCssString());
    }

    @Override
    public void setMaxWidth(Length maxWidth) {
        this.setCssStyle("max-width", maxWidth.toCssString());
    }

    @Override
    public void setMinHeight(Length minHeight) {
        this.setCssStyle("min-height", minHeight.toCssString());
    }

    @Override
    public void setMaxHeight(Length maxHeight) {
        this.setCssStyle("max-height", maxHeight.toCssString());
    }

    @Override
    public void setMargin(Spacing margin) {
        this.setCssStyle("margin", margin.toCssString());
    }

    @Override
    public void setShadow(Shadow shadow) {
        this.setCssStyle("box-shadow", shadow.toCssString());
    }

    @Override
    public void setCssStyle(String selector, String propertyName, String value) {
        if (selector == null) {
            selector = "";
        }
        CssStyles styles = this.stylesBySelector.computeIfAbsent(selector, s -> new CssStyles());
        styles.put(propertyName, value);
        String selector2 = selector;
        this.queueCommandIfRendered(() -> new UiComponent.SetStyleCommand(this.getId(), selector2, (Map)styles));
    }

    @Override
    public void setParent(Container container) {
        this.container = container;
    }

    @Override
    public Container getParent() {
        return this.container;
    }

    public String toString() {
        return this.id;
    }

    public String getDebuggingId() {
        return this.debuggingId;
    }

    public void setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
    }

    private static enum RenderingState {
        NOT_RENDERED,
        RENDERING,
        RENDERED;

    }
}

