/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiLabel;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;

public class Label
extends AbstractField<String> {
    public final Event<Void> onClicked = new Event();
    private String caption;
    private Icon icon;
    private Component targetComponent;

    public Label(String caption) {
        this.caption = caption;
    }

    public Label(String caption, Icon icon) {
        this(caption);
        this.icon = icon;
    }

    public UiField createUiComponent() {
        UiLabel uiLabel = new UiLabel(this.caption);
        this.mapAbstractFieldAttributesToUiField((UiField)uiLabel);
        uiLabel.setIcon(this.getSessionContext().resolveIcon(this.icon));
        uiLabel.setTargetComponent(this.targetComponent != null ? this.targetComponent.createUiReference() : null);
        return uiLabel;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_LABEL_CLICKED: {
                this.onClicked.fire(null);
            }
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.queueCommandIfRendered(() -> new UiLabel.SetCaptionCommand(this.getId(), caption));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.queueCommandIfRendered(() -> new UiLabel.SetIconCommand(this.getId(), this.getSessionContext().resolveIcon(icon)));
    }

    public Component getTargetComponent() {
        return this.targetComponent;
    }

    public Label setTargetComponent(Component targetComponent) {
        if (targetComponent == this) {
            throw new IllegalArgumentException("Labels may not reference themselves!");
        }
        this.targetComponent = targetComponent;
        this.queueCommandIfRendered(() -> new UiLabel.SetTargetComponentCommand(this.getId(), Component.createUiClientObjectReference(targetComponent)));
        return this;
    }
}

