/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import org.teamapps.dto.AbstractUiDateField;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;

public abstract class AbstractDateField<FIELD extends AbstractDateField<FIELD, VALUE>, VALUE>
extends AbstractField<VALUE>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    protected boolean showDropDownButton = true;
    protected boolean showClearButton = false;
    protected boolean favorPastDates = false;
    protected String dateFormat = null;

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    protected void mapAbstractDateFieldUiValues(AbstractUiDateField dateField) {
        this.mapAbstractFieldAttributesToUiField((UiField)dateField);
        dateField.setShowDropDownButton(this.showDropDownButton);
        dateField.setFavorPastDates(this.favorPastDates);
        dateField.setDateFormat(this.dateFormat);
        dateField.setShowClearButton(this.showClearButton);
    }

    public boolean isShowDropDownButton() {
        return this.showDropDownButton;
    }

    public void setShowDropDownButton(boolean showDropDownButton) {
        this.showDropDownButton = showDropDownButton;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetShowDropDownButtonCommand(this.getId(), showDropDownButton));
    }

    public boolean isFavorPastDates() {
        return this.favorPastDates;
    }

    public void setFavorPastDates(boolean favorPastDates) {
        this.favorPastDates = favorPastDates;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetFavorPastDatesCommand(this.getId(), favorPastDates));
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetDateFormatCommand(this.getId(), dateFormat));
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public void setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetShowClearButtonCommand(this.getId(), showClearButton));
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

