/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.List;
import java.util.UUID;
import org.teamapps.common.format.Color;
import org.teamapps.dto.AbstractUiLineChartDataDisplay;
import org.teamapps.dto.UiLongInterval;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartDataDisplayChangeListener;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;

public abstract class AbstractLineChartDataDisplay {
    private final String id = UUID.randomUUID().toString();
    protected LineChartDataDisplayChangeListener changeListener;
    private Interval intervalY;
    private ScaleType yScaleType = ScaleType.LINEAR;
    private LineChartYScaleZoomMode yScaleZoomMode = LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO;
    private boolean yZeroLineVisible = false;
    private Color yAxisColor = Color.BLACK;

    public String getId() {
        return this.id;
    }

    public abstract List<String> getDataSeriesIds();

    public abstract AbstractUiLineChartDataDisplay createUiFormat();

    public Interval getIntervalY() {
        return this.intervalY;
    }

    public AbstractLineChartDataDisplay setIntervalY(Interval intervalY) {
        this.intervalY = intervalY;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public ScaleType getyScaleType() {
        return this.yScaleType;
    }

    public AbstractLineChartDataDisplay setYScaleType(ScaleType yScaleType) {
        this.yScaleType = yScaleType;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public LineChartYScaleZoomMode getYScaleZoomMode() {
        return this.yScaleZoomMode;
    }

    public AbstractLineChartDataDisplay setYScaleZoomMode(LineChartYScaleZoomMode yScaleZoomMode) {
        this.yScaleZoomMode = yScaleZoomMode;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public void setChangeListener(LineChartDataDisplayChangeListener listener) {
        this.changeListener = listener;
    }

    protected void mapAbstractLineChartDataDisplayProperties(AbstractUiLineChartDataDisplay ui) {
        ui.setId(this.id);
        ui.setYAxisColor(this.yAxisColor != null ? this.yAxisColor.toHtmlColorString() : null);
        ui.setIntervalY(this.intervalY != null ? this.intervalY.createUiLongInterval() : new UiLongInterval(0L, 1000L));
        ui.setYScaleType(this.yScaleType.toUiScaleType());
        ui.setYScaleZoomMode(this.yScaleZoomMode.toUiLineChartYScaleZoomMode());
        ui.setYZeroLineVisible(this.yZeroLineVisible);
    }

    public boolean isYZeroLineVisible() {
        return this.yZeroLineVisible;
    }

    public AbstractLineChartDataDisplay setYZeroLineVisible(boolean yZeroLineVisible) {
        this.yZeroLineVisible = yZeroLineVisible;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getYAxisColor() {
        return this.yAxisColor;
    }

    public AbstractLineChartDataDisplay setYAxisColor(Color yAxisColor) {
        this.yAxisColor = yAxisColor;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }
}

