/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.event.Event;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartDataPoints;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.TimeGraphZoomLevel;

public class CompositeTimeGraphModel
implements TimeGraphModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeTimeGraphModel.class);
    private final Event<Void> onDataChanged = new Event();
    private final List<TimeGraphModel> delegates;

    public CompositeTimeGraphModel(TimeGraphModel ... delegates) {
        this.delegates = Arrays.asList(delegates);
        this.delegates.forEach(delegate -> delegate.onDataChanged().addListener(this.onDataChanged::fire));
    }

    @Override
    public Event<Void> onDataChanged() {
        return this.onDataChanged;
    }

    public List<TimeGraphZoomLevel> getZoomLevels() {
        return this.delegates.stream().flatMap(timeGraphModel -> timeGraphModel.getZoomLevels().stream()).distinct().sorted(Comparator.comparing(TimeGraphZoomLevel::getApproximateMillisecondsPerDataPoint).reversed()).collect(Collectors.toList());
    }

    @Override
    public Map<String, LineChartDataPoints> getDataPoints(Collection<String> lineIds, TimeGraphZoomLevel zoomLevel, Interval neededIntervalX, Interval displayedInterval) {
        Map points = this.delegates.stream().map(delegate -> delegate.getDataPoints(lineIds, zoomLevel, neededIntervalX, displayedInterval)).reduce((map1, map2) -> {
            HashMap<String, LineChartDataPoints> m = new HashMap<String, LineChartDataPoints>();
            m.putAll((Map<String, LineChartDataPoints>)map1);
            for (String lineName : map2.keySet()) {
                if (m.containsKey(lineName) && ((LineChartDataPoints)m.get(lineName)).size() > 0) continue;
                m.put(lineName, (LineChartDataPoints)map2.get(lineName));
            }
            return m;
        }).orElseGet(HashMap::new);
        int count = points.values().stream().mapToInt(LineChartDataPoints::size).sum();
        if (count > 10000) {
            LOGGER.debug("Number of datapoints {}", (Object)count);
        }
        return points;
    }

    @Override
    public Interval getDomainX(Collection<String> lineIds) {
        return this.delegates.stream().map(delegate -> delegate.getDomainX(lineIds)).filter(Objects::nonNull).reduce((interval1, interval2) -> new Interval(Math.min(interval1.getMin(), interval2.getMin()), Math.max(interval1.getMax(), interval2.getMax()))).orElseGet(() -> new Interval(0L, 1L));
    }
}

