/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiInfiniteItemView;
import org.teamapps.dto.UiMediaDeviceInfo;
import org.teamapps.dto.UiMediaServerUrlAndToken;
import org.teamapps.dto.UiMediaSoupPlaybackParameters;
import org.teamapps.dto.UiMediaSoupPublishingParameters;
import org.teamapps.dto.UiMediaSoupV3WebRtcClient;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.webrtc.AudioTrackConstraints;
import org.teamapps.ux.component.webrtc.MediaRetrievalFailureReason;
import org.teamapps.ux.component.webrtc.MediaSoupServerUrlAndToken;
import org.teamapps.ux.component.webrtc.ScreenSharingConstraints;
import org.teamapps.ux.component.webrtc.SourceMediaTrackType;
import org.teamapps.ux.component.webrtc.TrackPublishingFailedEventData;
import org.teamapps.ux.component.webrtc.TrackPublishingSuccessfulEventData;
import org.teamapps.ux.component.webrtc.VideoTrackConstraints;
import org.teamapps.ux.component.webrtc.WebRtcStreamType;
import org.teamapps.ux.session.SessionContext;

public class MediaSoupV3WebRtcClient
extends AbstractComponent {
    public final Event<MediaRetrievalFailureReason> onSourceMediaTrackRetrievalFailed = new Event();
    public final Event<SourceMediaTrackType> onSourceMediaTrackEnded = new Event();
    public final Event<TrackPublishingSuccessfulEventData> onTrackPublishingSuccessful = new Event();
    public final Event<TrackPublishingFailedEventData> onTrackPublishingFailed = new Event();
    public final Event<WebRtcStreamType> onPublishedStreamEnded = new Event();
    public final Event<Void> onSubscribingSuccessful = new Event();
    public final Event<String> onSubscribingFailed = new Event();
    public final Event<Boolean> onConnectionStateChanged = new Event();
    public final Event<Boolean> onVoiceActivityChanged = new Event();
    public final Event<Void> onClicked = new Event();
    private boolean activityLineVisible;
    private Color activityInactiveColor;
    private Color activityActiveColor;
    private boolean active;
    private List<Icon> icons = Collections.emptyList();
    private String caption;
    private String noVideoImageUrl;
    private Float displayAreaAspectRatio;
    private double playbackVolume = 1.0;
    private UiMediaSoupPublishingParameters publishingParameters;
    private UiMediaSoupPlaybackParameters playbackParameters;
    private Supplier<Component> contextMenuProvider = null;
    private int lastSeenContextMenuRequestId;
    private boolean bitrateDisplayEnabled;

    public UiMediaSoupV3WebRtcClient createUiComponent() {
        UiMediaSoupV3WebRtcClient ui = new UiMediaSoupV3WebRtcClient();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setPublishingParameters(this.publishingParameters);
        ui.setPlaybackParameters(this.playbackParameters);
        ui.setActivityLineVisible(this.activityLineVisible);
        ui.setActivityInactiveColor(this.activityInactiveColor != null ? this.activityInactiveColor.toHtmlColorString() : null);
        ui.setActivityActiveColor(this.activityActiveColor != null ? this.activityActiveColor.toHtmlColorString() : null);
        ui.setIcons(this.icons.stream().map(icon -> this.getSessionContext().resolveIcon((Icon)icon)).collect(Collectors.toList()));
        ui.setBitrateDisplayEnabled(this.bitrateDisplayEnabled);
        ui.setCaption(this.caption);
        ui.setNoVideoImageUrl(this.noVideoImageUrl);
        ui.setDisplayAreaAspectRatio(this.displayAreaAspectRatio);
        ui.setPlaybackVolume(this.playbackVolume);
        ui.setContextMenuEnabled(this.contextMenuProvider != null);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_VOICE_ACTIVITY_CHANGED: {
                UiMediaSoupV3WebRtcClient.VoiceActivityChangedEvent e = (UiMediaSoupV3WebRtcClient.VoiceActivityChangedEvent)event;
                this.onVoiceActivityChanged.fire(e.getActive());
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CLICKED: {
                UiMediaSoupV3WebRtcClient.ClickedEvent e = (UiMediaSoupV3WebRtcClient.ClickedEvent)event;
                this.onClicked.fire();
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SOURCE_MEDIA_TRACK_RETRIEVAL_FAILED: {
                UiMediaSoupV3WebRtcClient.SourceMediaTrackRetrievalFailedEvent e = (UiMediaSoupV3WebRtcClient.SourceMediaTrackRetrievalFailedEvent)event;
                this.onSourceMediaTrackRetrievalFailed.fire(MediaRetrievalFailureReason.valueOf(e.getReason().name()));
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SOURCE_MEDIA_TRACK_ENDED: {
                UiMediaSoupV3WebRtcClient.SourceMediaTrackEndedEvent e = (UiMediaSoupV3WebRtcClient.SourceMediaTrackEndedEvent)event;
                this.onSourceMediaTrackEnded.fire(SourceMediaTrackType.valueOf(e.getTrackType().name()));
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_TRACK_PUBLISHING_SUCCESSFUL: {
                UiMediaSoupV3WebRtcClient.TrackPublishingSuccessfulEvent e = (UiMediaSoupV3WebRtcClient.TrackPublishingSuccessfulEvent)event;
                this.onTrackPublishingSuccessful.fire(new TrackPublishingSuccessfulEventData(e.getAudio(), e.getVideo()));
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_TRACK_PUBLISHING_FAILED: {
                UiMediaSoupV3WebRtcClient.TrackPublishingFailedEvent e = (UiMediaSoupV3WebRtcClient.TrackPublishingFailedEvent)event;
                this.onTrackPublishingFailed.fire(new TrackPublishingFailedEventData(e.getAudio(), e.getVideo(), e.getErrorMessage()));
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SUBSCRIBING_SUCCESSFUL: {
                UiMediaSoupV3WebRtcClient.SubscribingSuccessfulEvent e = (UiMediaSoupV3WebRtcClient.SubscribingSuccessfulEvent)event;
                this.onSubscribingSuccessful.fire();
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SUBSCRIBING_FAILED: {
                UiMediaSoupV3WebRtcClient.SubscribingFailedEvent e = (UiMediaSoupV3WebRtcClient.SubscribingFailedEvent)event;
                this.onSubscribingFailed.fire(e.getErrorMessage());
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CONNECTION_STATE_CHANGED: {
                this.onConnectionStateChanged.fire(((UiMediaSoupV3WebRtcClient.ConnectionStateChangedEvent)event).getConnected());
                break;
            }
            case UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CONTEXT_MENU_REQUESTED: {
                UiMediaSoupV3WebRtcClient.ContextMenuRequestedEvent e = (UiMediaSoupV3WebRtcClient.ContextMenuRequestedEvent)event;
                this.lastSeenContextMenuRequestId = e.getRequestId();
                if (this.contextMenuProvider != null) {
                    Component contextMenuContent = this.contextMenuProvider.get();
                    if (contextMenuContent != null) {
                        this.queueCommandIfRendered(() -> new UiInfiniteItemView.SetContextMenuContentCommand(this.getId(), e.getRequestId(), contextMenuContent.createUiReference()));
                        break;
                    }
                    this.queueCommandIfRendered(() -> new UiInfiniteItemView.CloseContextMenuCommand(this.getId(), e.getRequestId()));
                    break;
                }
                this.closeContextMenu();
                break;
            }
        }
    }

    public void publish(String streamUuid, String serverUrl, int worker, String token, AudioTrackConstraints audioConstraints, VideoTrackConstraints videoConstraints, ScreenSharingConstraints screenSharingConstraints, long maxBitrate, boolean simulcast) {
        UiMediaSoupPublishingParameters params = new UiMediaSoupPublishingParameters();
        params.setServer(new UiMediaServerUrlAndToken(serverUrl, worker, token));
        params.setStreamUuid(streamUuid);
        params.setAudioConstraints(audioConstraints != null ? audioConstraints.createUiAudioTrackConstraints() : null);
        params.setVideoConstraints(videoConstraints != null ? videoConstraints.createUiVideoTrackConstraints() : null);
        params.setScreenSharingConstraints(screenSharingConstraints != null ? screenSharingConstraints.createUiScreenSharingConstraints() : null);
        params.setMaxBitrate(maxBitrate);
        params.setSimulcast(simulcast);
        this.publishingParameters = params;
        this.update();
    }

    public void play(String streamUuid, MediaSoupServerUrlAndToken server, boolean audio, boolean video, long minBitrate, long maxBitrate) {
        this.play(streamUuid, server, null, audio, video, minBitrate, maxBitrate);
    }

    public void play(String streamUuid, MediaSoupServerUrlAndToken server, MediaSoupServerUrlAndToken origin, boolean audio, boolean video, long minBitrate, long maxBitrate) {
        UiMediaSoupPlaybackParameters params = new UiMediaSoupPlaybackParameters();
        params.setStreamUuid(streamUuid);
        params.setServer(new UiMediaServerUrlAndToken(server.getServerUrl(), server.getWorker(), server.getToken()));
        params.setOrigin(origin != null ? new UiMediaServerUrlAndToken(origin.getServerUrl(), origin.getWorker(), origin.getToken()) : null);
        params.setAudio(audio);
        params.setVideo(video);
        params.setMinBitrate(minBitrate);
        params.setMaxBitrate(maxBitrate);
        this.playbackParameters = params;
        this.update();
    }

    public void stop() {
        this.publishingParameters = null;
        this.playbackParameters = null;
        this.update();
    }

    private void update() {
        this.queueCommandIfRendered(() -> new UiMediaSoupV3WebRtcClient.UpdateCommand(this.getId(), this.createUiComponent()));
    }

    public boolean isActivityLineVisible() {
        return this.activityLineVisible;
    }

    public void setActivityLineVisible(boolean activityLineVisible) {
        this.activityLineVisible = activityLineVisible;
        this.update();
    }

    public Color getActivityInactiveColor() {
        return this.activityInactiveColor;
    }

    public void setActivityInactiveColor(Color activityInactiveColor) {
        this.activityInactiveColor = activityInactiveColor;
        this.update();
    }

    public Color getActivityActiveColor() {
        return this.activityActiveColor;
    }

    public void setActivityActiveColor(Color activityActiveColor) {
        this.activityActiveColor = activityActiveColor;
        this.update();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active != this.active) {
            this.active = active;
            this.queueCommandIfRendered(() -> new UiMediaSoupV3WebRtcClient.SetActiveCommand(this.getId(), active));
        }
    }

    public List<Icon> getIcons() {
        return this.icons;
    }

    public void setIcons(List<Icon> icons) {
        if (icons == null) {
            icons = Collections.emptyList();
        }
        if (!Objects.equals(icons, this.icons)) {
            this.icons = icons;
            this.update();
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        if (!Objects.equals(caption, this.caption)) {
            this.caption = caption;
            this.update();
        }
    }

    public String getNoVideoImageUrl() {
        return this.noVideoImageUrl;
    }

    public void setNoVideoImageUrl(String noVideoImageUrl) {
        if (!Objects.equals(noVideoImageUrl, this.noVideoImageUrl)) {
            this.noVideoImageUrl = noVideoImageUrl;
            this.update();
        }
    }

    public Float getDisplayAreaAspectRatio() {
        return this.displayAreaAspectRatio;
    }

    public void setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
        if (!Objects.equals(displayAreaAspectRatio, this.displayAreaAspectRatio)) {
            this.displayAreaAspectRatio = displayAreaAspectRatio;
            this.update();
        }
    }

    public double getPlaybackVolume() {
        return this.playbackVolume;
    }

    public void setPlaybackVolume(double playbackVolume) {
        if (playbackVolume != this.playbackVolume) {
            this.playbackVolume = playbackVolume;
            this.update();
        }
    }

    public boolean isBitrateDisplayEnabled() {
        return this.bitrateDisplayEnabled;
    }

    public void setBitrateDisplayEnabled(boolean bitrateDisplayEnabled) {
        if (bitrateDisplayEnabled != this.bitrateDisplayEnabled) {
            this.bitrateDisplayEnabled = bitrateDisplayEnabled;
            this.update();
        }
    }

    public static CompletableFuture<List<UiMediaDeviceInfo>> enumerateDevices() {
        CompletableFuture<List<UiMediaDeviceInfo>> future = new CompletableFuture<List<UiMediaDeviceInfo>>();
        SessionContext.current().queueCommand(new UiMediaSoupV3WebRtcClient.EnumerateDevicesCommand(), value -> future.complete((List<UiMediaDeviceInfo>)value));
        return future;
    }

    public Supplier<Component> getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public void setContextMenuProvider(Supplier<Component> contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    public void closeContextMenu() {
        this.queueCommandIfRendered(() -> new UiInfiniteItemView.CloseContextMenuCommand(this.getId(), this.lastSeenContextMenuRequestId));
    }
}

