/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.teamapps.ux.i18n.ResourceBundleTranslationProvider;

public interface TranslationProvider {
    public static TranslationProvider createFromResourceBundle(String baseName, Locale ... languages) {
        return TranslationProvider.createFromResourceBundle(baseName, "properties", languages);
    }

    public static TranslationProvider createFromResourceBundle(String baseName, String resourceFileSuffix, Locale ... languages) {
        return new ResourceBundleTranslationProvider(baseName, resourceFileSuffix, languages);
    }

    public List<Locale> getLanguages();

    public List<String> getKeys();

    default public List<String> getKeys(Locale locale) {
        return this.getKeys().stream().filter(key -> this.getTranslation((String)key, locale) != null).collect(Collectors.toList());
    }

    public String getTranslation(String var1, Locale var2);

    default public String getTranslation(String key, List<Locale> acceptedLanguages) {
        for (Locale locale : acceptedLanguages) {
            String translation = this.getTranslation(key, locale);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    default public String getTranslation(String key, Locale ... acceptedLanguages) {
        return this.getTranslation(key, Arrays.asList(acceptedLanguages));
    }
}

