/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.media;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiVideoPlayer;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.media.PosterImageSize;
import org.teamapps.ux.component.media.PreloadMode;

public class VideoPlayer
extends AbstractComponent {
    public final Event<Void> onErrorLoading = new Event();
    public final Event<Integer> onProgress = new Event();
    public final Event<Void> onEnded = new Event();
    private String url;
    private boolean autoplay;
    private boolean showControls;
    private String posterImageUrl;
    private PosterImageSize posterImageSize = PosterImageSize.COVER;
    private int sendPlayerProgressEventsEachXSeconds = 1;
    private Color backgroundColor = new Color(68, 68, 68);
    private PreloadMode preloadMode = PreloadMode.METADATA;

    public VideoPlayer() {
    }

    public VideoPlayer(String url) {
        this.url = url;
    }

    @Override
    public UiComponent createUiComponent() {
        UiVideoPlayer uiVideoPlayer = new UiVideoPlayer(this.url);
        this.mapAbstractUiComponentProperties((UiComponent)uiVideoPlayer);
        uiVideoPlayer.setAutoplay(this.autoplay);
        uiVideoPlayer.setShowControls(this.showControls);
        uiVideoPlayer.setPosterImageUrl(this.posterImageUrl);
        uiVideoPlayer.setPosterImageSize(this.posterImageSize.toUiPosterImageSize());
        uiVideoPlayer.setSendPlayerProgressEventsEachXSeconds(this.sendPlayerProgressEventsEachXSeconds);
        uiVideoPlayer.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        uiVideoPlayer.setPreloadMode(this.preloadMode.toUiPreloadMode());
        return uiVideoPlayer;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_VIDEO_PLAYER_ERROR_LOADING: {
                this.onErrorLoading.fire(null);
                break;
            }
            case UI_VIDEO_PLAYER_PLAYER_PROGRESS: {
                UiVideoPlayer.PlayerProgressEvent e = (UiVideoPlayer.PlayerProgressEvent)event;
                this.onProgress.fire(e.getPositionInSeconds());
                break;
            }
            case UI_VIDEO_PLAYER_ENDED: {
                this.onEnded.fire();
            }
        }
    }

    public void play() {
        this.queueCommandIfRendered(() -> new UiVideoPlayer.PlayCommand(this.getId()));
    }

    public void pause() {
        this.queueCommandIfRendered(() -> new UiVideoPlayer.PauseCommand(this.getId()));
    }

    public void setPosition(int timeInSeconds) {
        this.queueCommandIfRendered(() -> new UiVideoPlayer.JumpToCommand(this.getId(), timeInSeconds));
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.queueCommandIfRendered(() -> new UiVideoPlayer.SetUrlCommand(this.getId(), url));
    }

    public boolean isAutoplay() {
        return this.autoplay;
    }

    public void setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
        this.queueCommandIfRendered(() -> new UiVideoPlayer.SetAutoplayCommand(this.getId(), autoplay));
    }

    public boolean isShowControls() {
        return this.showControls;
    }

    public void setShowControls(boolean showControls) {
        this.showControls = showControls;
        this.reRenderIfRendered();
    }

    public String getPosterImageUrl() {
        return this.posterImageUrl;
    }

    public void setPosterImageUrl(String posterImageUrl) {
        this.posterImageUrl = posterImageUrl;
        this.reRenderIfRendered();
    }

    public PosterImageSize getPosterImageSize() {
        return this.posterImageSize;
    }

    public void setPosterImageSize(PosterImageSize posterImageSize) {
        this.posterImageSize = posterImageSize;
        this.reRenderIfRendered();
    }

    public int getSendPlayerProgressEventsEachXSeconds() {
        return this.sendPlayerProgressEventsEachXSeconds;
    }

    public void setSendPlayerProgressEventsEachXSeconds(int sendPlayerProgressEventsEachXSeconds) {
        this.sendPlayerProgressEventsEachXSeconds = sendPlayerProgressEventsEachXSeconds;
        this.reRenderIfRendered();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.reRenderIfRendered();
    }

    public PreloadMode getPreloadMode() {
        return this.preloadMode;
    }

    public void setPreloadMode(PreloadMode preloadMode) {
        this.preloadMode = preloadMode;
        this.queueCommandIfRendered(() -> new UiVideoPlayer.SetPreloadModeCommand(this.getId(), preloadMode.toUiPreloadMode()));
    }
}

