/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.application.Application;
import org.teamapps.ux.application.ApplicationChangeHandler;
import org.teamapps.ux.application.ResponsiveApplicationImpl;
import org.teamapps.ux.application.assembler.AdditionalNavigationButton;
import org.teamapps.ux.application.assembler.DesktopApplicationAssembler;
import org.teamapps.ux.application.assembler.MobileApplicationAssembler;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.icon.TeamAppsIconBundle;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public interface ResponsiveApplication
extends Application {
    public static ResponsiveApplication createApplication() {
        return ResponsiveApplication.createApplication(null);
    }

    public static ResponsiveApplication createApplication(View applicationLauncher) {
        return ResponsiveApplication.createApplication(applicationLauncher, SessionContext.current().getIcon(TeamAppsIconBundle.APPLICATION_LAUNCHER.getKey()), SessionContext.current().getIcon(TeamAppsIconBundle.TREE.getKey()), SessionContext.current().getIcon(TeamAppsIconBundle.VIEWS.getKey()), SessionContext.current().getIcon(TeamAppsIconBundle.TOOLBAR.getKey()), SessionContext.current().getIcon(TeamAppsIconBundle.TOOLBAR.getKey()));
    }

    public static ResponsiveApplication createApplication(View applicationLauncher, Icon launcherIcon, Icon treeIcon, Icon viewsIcon, Icon toolbarIcon, Icon backIcon) {
        boolean mobileDevice = CurrentSessionContext.get().getClientInfo().isMobileDevice();
        if (mobileDevice) {
            MobileApplicationAssembler mobileAssembler = new MobileApplicationAssembler(launcherIcon, treeIcon, viewsIcon, toolbarIcon, backIcon, null);
            mobileAssembler.setApplicationLauncher(applicationLauncher);
            return new ResponsiveApplicationImpl(mobileAssembler);
        }
        return new ResponsiveApplicationImpl(new DesktopApplicationAssembler());
    }

    public static ResponsiveApplication createApplication(Icon treeIcon, Icon viewsIcon, Icon toolbarIcon, Icon backIcon, List<AdditionalNavigationButton> additionalLeftButtons) {
        boolean mobileDevice = CurrentSessionContext.get().getClientInfo().isMobileDevice();
        if (mobileDevice) {
            MobileApplicationAssembler mobileAssembler = new MobileApplicationAssembler(null, treeIcon, viewsIcon, toolbarIcon, backIcon, additionalLeftButtons);
            return new ResponsiveApplicationImpl(mobileAssembler);
        }
        return new ResponsiveApplicationImpl(new DesktopApplicationAssembler());
    }

    public void addApplicationChangeHandler(ApplicationChangeHandler var1);

    public void removeApplicationChangeHandler(ApplicationChangeHandler var1);

    public void addApplicationView(View var1);

    public void removeApplicationView(View var1);

    public List<View> getApplicationViews();

    public List<Perspective> getPerspectives();

    public Perspective addPerspective(Perspective var1);

    public void showPerspective(Perspective var1);

    public Perspective getActivePerspective();

    public List<View> getActiveViews();

    public ToolbarButtonGroup addApplicationButtonGroup(ToolbarButtonGroup var1);

    public void removeApplicationButtonGroup(ToolbarButtonGroup var1);

    public List<ToolbarButtonGroup> getWorkspaceButtonGroups();

    public void setToolbarBackgroundColor(Color var1);

    public MultiProgressDisplay getMultiProgressDisplay();
}

