/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.charting.forcelayout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutLink;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutNode;

public class GraphChangeOperation<RECORD> {
    private final List<ForceLayoutNode<RECORD>> addedNodes = new ArrayList<ForceLayoutNode<RECORD>>();
    private List<ForceLayoutLink<RECORD>> addedLinks = new ArrayList<ForceLayoutLink<RECORD>>();
    private List<ForceLayoutNode<RECORD>> removedNodes = new ArrayList<ForceLayoutNode<RECORD>>();
    private List<ForceLayoutLink<RECORD>> removedLinks = new ArrayList<ForceLayoutLink<RECORD>>();
    private final Map<RECORD, ForceLayoutNode<RECORD>> graphNodeByNode = new HashMap<RECORD, ForceLayoutNode<RECORD>>();

    public GraphChangeOperation() {
    }

    public GraphChangeOperation(List<ForceLayoutNode<RECORD>> nodes, List<ForceLayoutLink<RECORD>> links, boolean remove) {
        if (remove) {
            this.removedNodes = nodes;
            this.removedLinks = links;
        } else {
            this.addedNodes.forEach(record -> this.addNode((ForceLayoutNode<RECORD>)record));
            this.addedLinks = links;
        }
    }

    public boolean containsAddOperations() {
        return !this.addedNodes.isEmpty() || !this.addedLinks.isEmpty();
    }

    public boolean containsRemoveOperations() {
        return !this.removedNodes.isEmpty() || !this.removedLinks.isEmpty();
    }

    public void addNode(ForceLayoutNode<RECORD> record) {
        this.addedNodes.add(record);
        this.graphNodeByNode.put(record.getRecord(), record);
    }

    public void addLink(ForceLayoutLink<RECORD> link) {
        this.addedLinks.add(link);
    }

    public List<ForceLayoutNode<RECORD>> getAddedNodes() {
        return this.addedNodes;
    }

    public void setAddedNodes(List<ForceLayoutNode<RECORD>> addedNodes) {
        addedNodes.forEach(record -> this.addNode((ForceLayoutNode<RECORD>)record));
    }

    public List<ForceLayoutLink<RECORD>> getAddedLinks() {
        return this.addedLinks;
    }

    public void setAddedLinks(List<ForceLayoutLink<RECORD>> addedLinks) {
        this.addedLinks = addedLinks;
    }

    public List<ForceLayoutNode<RECORD>> getRemovedNodes() {
        return this.removedNodes;
    }

    public void setRemovedNodes(List<ForceLayoutNode<RECORD>> removedNodes) {
        this.removedNodes = removedNodes;
    }

    public List<ForceLayoutLink<RECORD>> getRemovedLinks() {
        return this.removedLinks;
    }

    public void setRemovedLinks(List<ForceLayoutLink<RECORD>> removedLinks) {
        this.removedLinks = removedLinks;
    }

    public Map<RECORD, ForceLayoutNode<RECORD>> getGraphNodeByNode() {
        return this.graphNodeByNode;
    }
}

