/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiHtmlView;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.ClientObject;
import org.teamapps.ux.component.Component;

public class HtmlView
extends AbstractComponent {
    private String html;
    private final Map<String, List<Component>> componentsByContainerElementSelector = new HashMap<String, List<Component>>();
    private final Map<String, String> contentHtmlByContainerElementSelector = new HashMap<String, String>();

    public HtmlView() {
        this(null, Collections.emptyMap(), Collections.emptyMap());
    }

    public HtmlView(String html) {
        this(html, Collections.emptyMap(), Collections.emptyMap());
    }

    public HtmlView(String html, Map<String, List<Component>> componentsByContainerElementSelector, Map<String, String> contentHtmlByContainerElementSelector) {
        this.html = html;
        this.componentsByContainerElementSelector.putAll(componentsByContainerElementSelector);
        this.contentHtmlByContainerElementSelector.putAll(contentHtmlByContainerElementSelector);
    }

    @Override
    public UiComponent createUiComponent() {
        UiHtmlView ui = new UiHtmlView();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setHtml(this.html);
        ui.setComponentsByContainerElementSelector(this.componentsByContainerElementSelector.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(ClientObject::createUiReference).collect(Collectors.toList()))));
        ui.setContentHtmlByContainerElementSelector(this.contentHtmlByContainerElementSelector.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue)));
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public void addComponent(String containerSelector, Component component) {
        this.componentsByContainerElementSelector.computeIfAbsent(containerSelector, s -> new ArrayList()).add(component);
        this.queueCommandIfRendered(() -> new UiHtmlView.AddComponentCommand(this.getId(), containerSelector, component.createUiReference()));
    }

    public void removeComponent(Component component) {
        this.componentsByContainerElementSelector.entrySet().removeIf(entry -> entry.getValue() == component);
        this.queueCommandIfRendered(() -> new UiHtmlView.RemoveComponentCommand(this.getId(), component.createUiReference()));
    }

    public void setContentHtml(String containerElementSelector, String html) {
        this.contentHtmlByContainerElementSelector.put(containerElementSelector, html);
        this.queueCommandIfRendered(() -> new UiHtmlView.SetContentHtmlCommand(this.getId(), containerElementSelector, html));
    }
}

