/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.node.TreeNode;
import org.teamapps.ux.component.template.BaseTemplateRecord;

public class BaseTemplateTreeNode<PAYLOAD>
extends BaseTemplateRecord<PAYLOAD>
implements TreeNode {
    private BaseTemplateTreeNode<PAYLOAD> parent;
    private boolean lazyChildren;
    private boolean expanded;

    public BaseTemplateTreeNode() {
    }

    public BaseTemplateTreeNode(String caption) {
        super(caption);
    }

    public BaseTemplateTreeNode(Icon icon, String caption) {
        super(icon, caption);
    }

    public BaseTemplateTreeNode(Icon icon, String caption, String description) {
        super(icon, caption, description);
    }

    public BaseTemplateTreeNode(Icon icon, String caption, String description, String badge) {
        super(icon, caption, description, badge);
    }

    public BaseTemplateTreeNode(String image, String caption) {
        super(image, caption);
    }

    public BaseTemplateTreeNode(String image, String caption, String description) {
        super(image, caption, description);
    }

    public BaseTemplateTreeNode(String image, String caption, String description, String badge) {
        super(image, caption, description, badge);
    }

    public BaseTemplateTreeNode(Icon icon, String image, String caption, String description, String badge) {
        super(icon, image, caption, description, badge);
    }

    public BaseTemplateTreeNode(Icon icon, String image, String caption, String description, String badge, PAYLOAD payload) {
        super(icon, image, caption, description, badge, payload);
    }

    public BaseTemplateTreeNode<PAYLOAD> copy() {
        BaseTemplateTreeNode<PAYLOAD> copy = new BaseTemplateTreeNode<PAYLOAD>(this.getIcon(), this.getImage(), this.getCaption(), this.getDescription(), this.getBadge(), this.getPayload());
        copy.setParent(this.parent);
        copy.setLazyChildren(this.lazyChildren);
        copy.setExpanded(this.expanded);
        return copy;
    }

    @Override
    public BaseTemplateTreeNode<PAYLOAD> setPayload(PAYLOAD payload) {
        super.setPayload(payload);
        return this;
    }

    @Override
    public BaseTemplateTreeNode<PAYLOAD> getParent() {
        return this.parent;
    }

    public BaseTemplateTreeNode<PAYLOAD> setParent(BaseTemplateTreeNode<PAYLOAD> parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public boolean isLazyChildren() {
        return this.lazyChildren;
    }

    public void setLazyChildren(boolean lazyChildren) {
        this.lazyChildren = lazyChildren;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public static <PAYLOAD> List<BaseTemplateTreeNode<PAYLOAD>> copyTree(List<BaseTemplateTreeNode<PAYLOAD>> tree) {
        Map<BaseTemplateTreeNode, BaseTemplateTreeNode> copysByOriginal = tree.stream().collect(Collectors.toMap(node -> node, node -> node.copy()));
        copysByOriginal.values().forEach(node -> node.setParent(node.getParent() != null ? (BaseTemplateTreeNode)copysByOriginal.get(node.getParent()) : null));
        return new ArrayList<BaseTemplateTreeNode<PAYLOAD>>(copysByOriginal.values());
    }
}

