/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.workspacelayout;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiWorkSpaceLayoutItem;
import org.teamapps.dto.UiWorkSpaceLayoutSplitItem;
import org.teamapps.dto.UiWorkSpaceLayoutViewGroupItem;
import org.teamapps.ux.component.splitpane.SplitSizePolicy;
import org.teamapps.ux.component.workspacelayout.SplitDirection;
import org.teamapps.ux.component.workspacelayout.ViewGroupPanelState;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutItem;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutSplitPane;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutView;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutViewGroup;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;
import org.teamapps.ux.component.workspacelayout.definition.SplitPaneDefinition;
import org.teamapps.ux.component.workspacelayout.definition.ViewGroupDefinition;

class LayoutApplyer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayoutApplyer.class);
    private final WorkSpaceLayout workSpaceLayout;
    private Map<String, LayoutItemWrapper> descriptorItemById;
    private Set<String> descriptorViewNames;
    private Map<String, WorkSpaceLayoutItem> itemsById;
    private Map<String, WorkSpaceLayoutView> viewsByName;

    public LayoutApplyer(WorkSpaceLayout workSpaceLayout) {
        this.workSpaceLayout = workSpaceLayout;
    }

    public Map<String, WorkSpaceLayoutItem> applyFromUiLayoutDescriptor(Map<String, WorkSpaceLayoutItem> currentRootItemsByWindowId, Map<String, UiWorkSpaceLayoutItem> newRootDescriptorsByWindowId) {
        Map<String, LayoutItemWrapper> wrappedDescriptors = newRootDescriptorsByWindowId.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> LayoutApplyer.createWrapperFromUi((UiWorkSpaceLayoutItem)entry.getValue())));
        return this.apply(currentRootItemsByWindowId, wrappedDescriptors);
    }

    public Map<String, WorkSpaceLayoutItem> applyFromLayoutDefinition(Map<String, WorkSpaceLayoutItem> currentRootItemsByWindowId, Map<String, LayoutItemDefinition> newRootDescriptorsByWindowId) {
        Map<String, LayoutItemWrapper> wrappedDescriptors = newRootDescriptorsByWindowId.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> LayoutApplyer.createWrapperFromDefinition((LayoutItemDefinition)entry.getValue())));
        return this.apply(currentRootItemsByWindowId, wrappedDescriptors);
    }

    public Map<String, WorkSpaceLayoutItem> apply(Map<String, WorkSpaceLayoutItem> currentRootItemsByWindowId, Map<String, LayoutItemWrapper> newRootDescriptorsByWindowId) {
        this.reset();
        newRootDescriptorsByWindowId.forEach((windowId, layoutDescriptor) -> this.putToDescriptorDictionaries((LayoutItemWrapper)layoutDescriptor));
        currentRootItemsByWindowId.forEach((windowId, currentRootItem) -> this.putToServerItemDictionaries((WorkSpaceLayoutItem)currentRootItem));
        currentRootItemsByWindowId.forEach((windowId, currentRootItem) -> {
            LayoutItemWrapper newLayoutDescriptor = (LayoutItemWrapper)newRootDescriptorsByWindowId.get(windowId);
            this.cleanupUnknownServerItems((WorkSpaceLayoutItem)currentRootItem, newLayoutDescriptor, null);
        });
        Map<String, WorkSpaceLayoutItem> newRootItemsByWindowId = newRootDescriptorsByWindowId.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.addNewStructure((LayoutItemWrapper)e.getValue(), null, false)));
        return newRootItemsByWindowId;
    }

    private void reset() {
        this.descriptorItemById = new HashMap<String, LayoutItemWrapper>();
        this.descriptorViewNames = new HashSet<String>();
        this.itemsById = new HashMap<String, WorkSpaceLayoutItem>();
        this.viewsByName = new HashMap<String, WorkSpaceLayoutView>();
    }

    private void putToDescriptorDictionaries(LayoutItemWrapper descriptorItem) {
        this.descriptorItemById.put(descriptorItem.getId(), descriptorItem);
        if (descriptorItem instanceof ViewGroupWrapper) {
            ViewGroupWrapper viewGroupItem = (ViewGroupWrapper)descriptorItem;
            this.descriptorViewNames.addAll(viewGroupItem.getViewNames());
        } else if (descriptorItem instanceof SplitPaneWrapper) {
            SplitPaneWrapper splitItem = (SplitPaneWrapper)descriptorItem;
            if (splitItem.getFirstChild() != null) {
                this.putToDescriptorDictionaries(splitItem.getFirstChild());
            }
            if (splitItem.getLastChild() != null) {
                this.putToDescriptorDictionaries(splitItem.getLastChild());
            }
        }
    }

    private void putToServerItemDictionaries(WorkSpaceLayoutItem item) {
        if (item == null) {
            return;
        }
        this.itemsById.put(item.getId(), item);
        if (item instanceof WorkSpaceLayoutViewGroup) {
            ((WorkSpaceLayoutViewGroup)item).getViews().forEach(view -> this.viewsByName.put(view.getId(), (WorkSpaceLayoutView)view));
        } else if (item instanceof WorkSpaceLayoutSplitPane) {
            WorkSpaceLayoutItem lastChild;
            WorkSpaceLayoutItem firstChild = ((WorkSpaceLayoutSplitPane)item).getFirstChild();
            if (firstChild != null) {
                this.putToServerItemDictionaries(firstChild);
            }
            if ((lastChild = ((WorkSpaceLayoutSplitPane)item).getLastChild()) != null) {
                this.putToServerItemDictionaries(lastChild);
            }
        }
    }

    public void cleanupUnknownServerItems(WorkSpaceLayoutItem item, LayoutItemWrapper descriptorItem, WorkSpaceLayoutSplitPane parent) {
        if (descriptorItem != null && Objects.equals(descriptorItem.getId(), item.getId())) {
            if (item instanceof WorkSpaceLayoutSplitPane) {
                WorkSpaceLayoutItem lastChild;
                WorkSpaceLayoutSplitPane splitPane = (WorkSpaceLayoutSplitPane)item;
                WorkSpaceLayoutItem firstChild = splitPane.getFirstChild();
                if (firstChild != null) {
                    this.cleanupUnknownServerItems(firstChild, ((SplitPaneWrapper)descriptorItem).getFirstChild(), splitPane);
                }
                if ((lastChild = splitPane.getLastChild()) != null) {
                    this.cleanupUnknownServerItems(lastChild, ((SplitPaneWrapper)descriptorItem).getLastChild(), splitPane);
                }
            } else if (item instanceof WorkSpaceLayoutViewGroup) {
                this.removeUnknownViews((WorkSpaceLayoutViewGroup)item, ((ViewGroupWrapper)descriptorItem).getViewNames());
            }
        } else {
            LayoutItemWrapper correspondingDescriptorItem = this.descriptorItemById.get(item.getId());
            if (correspondingDescriptorItem != null) {
                this.cleanupUnknownServerItems(item, correspondingDescriptorItem, null);
            } else if (item instanceof WorkSpaceLayoutViewGroup) {
                this.removeUnknownViews((WorkSpaceLayoutViewGroup)item, Collections.emptyList());
            } else if (item instanceof WorkSpaceLayoutSplitPane) {
                this.cleanupUnknownServerItems(((WorkSpaceLayoutSplitPane)item).getFirstChild(), null, (WorkSpaceLayoutSplitPane)item);
                this.cleanupUnknownServerItems(((WorkSpaceLayoutSplitPane)item).getLastChild(), null, (WorkSpaceLayoutSplitPane)item);
            }
            if (parent != null) {
                if (item == parent.getFirstChild()) {
                    parent.setFirstChildSilently(null);
                } else {
                    parent.setLastChildSilently(null);
                }
            }
        }
    }

    private void removeUnknownViews(WorkSpaceLayoutViewGroup viewGroup, List<String> descriptorViewNames) {
        List<WorkSpaceLayoutView> viewsToBeRemoved = viewGroup.getViews().stream().filter(view -> !descriptorViewNames.contains(view.getId())).collect(Collectors.toList());
        viewsToBeRemoved.forEach(viewGroup::handleViewRemovedByClient);
    }

    private WorkSpaceLayoutItem addNewStructure(LayoutItemWrapper descriptor, WorkSpaceLayoutSplitPane parent, boolean firstChild) {
        WorkSpaceLayoutItem item;
        if (descriptor == null) {
            return null;
        }
        WorkSpaceLayoutItem serverSideItem = this.itemsById.get(descriptor.getId());
        if (serverSideItem != null) {
            item = serverSideItem;
            if (descriptor instanceof SplitPaneWrapper) {
                SplitPaneWrapper splitDescriptor = (SplitPaneWrapper)descriptor;
                WorkSpaceLayoutSplitPane splitPaneItem = (WorkSpaceLayoutSplitPane)serverSideItem;
                this.addNewStructure(splitDescriptor.getFirstChild(), splitPaneItem, true);
                this.addNewStructure(splitDescriptor.getLastChild(), splitPaneItem, false);
                splitPaneItem.setSizePolicySilently(SplitSizePolicy.valueOf(splitDescriptor.getSizePolicy().name()));
                splitPaneItem.setReferenceChildSizeSilently(splitDescriptor.getReferenceChildSize());
            } else if (descriptor instanceof ViewGroupWrapper) {
                ViewGroupWrapper viewGroupDescriptor = (ViewGroupWrapper)descriptor;
                WorkSpaceLayoutViewGroup viewGroup = (WorkSpaceLayoutViewGroup)serverSideItem;
                this.addViews(viewGroup, viewGroupDescriptor);
                viewGroup.setPanelStateSilently(ViewGroupPanelState.valueOf(viewGroupDescriptor.getPanelState().name()));
            }
        } else {
            item = this.createTreeItemFromLayoutDescriptor(descriptor);
        }
        if (parent != null) {
            if (firstChild) {
                parent.setFirstChildSilently(item);
            } else {
                parent.setLastChildSilently(item);
            }
        }
        return item;
    }

    private WorkSpaceLayoutItem createTreeItemFromLayoutDescriptor(LayoutItemWrapper descriptor) {
        if (descriptor instanceof ViewGroupWrapper) {
            ViewGroupWrapper viewGroupWrapper = (ViewGroupWrapper)descriptor;
            WorkSpaceLayoutViewGroup tabPanelItem = new WorkSpaceLayoutViewGroup(descriptor.getId(), viewGroupWrapper.isPersistent(), this.workSpaceLayout);
            this.addViews(tabPanelItem, viewGroupWrapper);
            return tabPanelItem;
        }
        SplitPaneWrapper splitDescriptor = (SplitPaneWrapper)descriptor;
        WorkSpaceLayoutSplitPane splitPaneItem = new WorkSpaceLayoutSplitPane(descriptor.getId(), SplitDirection.valueOf(splitDescriptor.getSplitDirection().name()), SplitSizePolicy.valueOf(splitDescriptor.getSizePolicy().name()), splitDescriptor.getReferenceChildSize(), this.workSpaceLayout);
        splitPaneItem.setFirstChildSilently(this.addNewStructure(splitDescriptor.getFirstChild(), splitPaneItem, true));
        splitPaneItem.setLastChildSilently(this.addNewStructure(splitDescriptor.getLastChild(), splitPaneItem, false));
        return splitPaneItem;
    }

    private void addViews(WorkSpaceLayoutViewGroup viewGroup, ViewGroupWrapper viewGroupDescriptor) {
        for (int i = 0; i < viewGroupDescriptor.getViewNames().size(); ++i) {
            String viewName = viewGroupDescriptor.getViewNames().get(i);
            boolean selected = Objects.equals(viewName, viewGroupDescriptor.getSelectedViewName()) || viewGroupDescriptor.getSelectedViewName() == null && i == 0;
            WorkSpaceLayoutView view = this.viewsByName.get(viewName);
            if (view == null) continue;
            viewGroup.addViewSilently(view, i, selected);
        }
    }

    private static LayoutItemWrapper createWrapperFromUi(UiWorkSpaceLayoutItem child) {
        if (child instanceof UiWorkSpaceLayoutSplitItem) {
            return new UiWorkSpaceLayoutSplitItemWrapper((UiWorkSpaceLayoutSplitItem)child);
        }
        if (child instanceof UiWorkSpaceLayoutViewGroupItem) {
            return new UiWorkSpaceLayoutViewGroupItemWrapper((UiWorkSpaceLayoutViewGroupItem)child);
        }
        throw new IllegalArgumentException("Unknown layout item type " + child.getClass().getCanonicalName());
    }

    private static LayoutItemWrapper createWrapperFromDefinition(LayoutItemDefinition child) {
        if (child instanceof SplitPaneDefinition) {
            return new LayoutSplitPaneDefinitionWrapper((SplitPaneDefinition)child);
        }
        if (child instanceof ViewGroupDefinition) {
            return new LayoutViewGroupDefinitionWrapper((ViewGroupDefinition)child);
        }
        throw new IllegalArgumentException("Unknown layout item type " + child.getClass().getCanonicalName());
    }

    private static interface LayoutItemWrapper {
        public String getId();
    }

    private static interface ViewGroupWrapper
    extends LayoutItemWrapper {
        public List<String> getViewNames();

        public String getSelectedViewName();

        public boolean isPersistent();

        public ViewGroupPanelState getPanelState();
    }

    private static interface SplitPaneWrapper
    extends LayoutItemWrapper {
        public SplitDirection getSplitDirection();

        public SplitSizePolicy getSizePolicy();

        public float getReferenceChildSize();

        public LayoutItemWrapper getFirstChild();

        public LayoutItemWrapper getLastChild();
    }

    private static class UiWorkSpaceLayoutSplitItemWrapper
    implements SplitPaneWrapper {
        private final UiWorkSpaceLayoutSplitItem item;

        public UiWorkSpaceLayoutSplitItemWrapper(UiWorkSpaceLayoutSplitItem item) {
            this.item = item;
        }

        @Override
        public String getId() {
            return this.item.getId();
        }

        @Override
        public SplitDirection getSplitDirection() {
            return SplitDirection.valueOf(this.item.getSplitDirection().name());
        }

        @Override
        public SplitSizePolicy getSizePolicy() {
            return SplitSizePolicy.valueOf(this.item.getSizePolicy().name());
        }

        @Override
        public float getReferenceChildSize() {
            return this.item.getReferenceChildSize();
        }

        @Override
        public LayoutItemWrapper getFirstChild() {
            return LayoutApplyer.createWrapperFromUi(this.item.getFirstChild());
        }

        @Override
        public LayoutItemWrapper getLastChild() {
            return LayoutApplyer.createWrapperFromUi(this.item.getLastChild());
        }
    }

    private static class UiWorkSpaceLayoutViewGroupItemWrapper
    implements ViewGroupWrapper {
        private final UiWorkSpaceLayoutViewGroupItem item;

        public UiWorkSpaceLayoutViewGroupItemWrapper(UiWorkSpaceLayoutViewGroupItem item) {
            this.item = item;
        }

        @Override
        public List<String> getViewNames() {
            return this.item.getViewNames();
        }

        @Override
        public String getSelectedViewName() {
            return this.item.getSelectedViewName();
        }

        @Override
        public boolean isPersistent() {
            return this.item.getPersistent();
        }

        @Override
        public ViewGroupPanelState getPanelState() {
            return ViewGroupPanelState.valueOf(this.item.getPanelState().name());
        }

        @Override
        public String getId() {
            return this.item.getId();
        }
    }

    private static class LayoutSplitPaneDefinitionWrapper
    implements SplitPaneWrapper {
        private final SplitPaneDefinition item;

        public LayoutSplitPaneDefinitionWrapper(SplitPaneDefinition item) {
            this.item = item;
        }

        @Override
        public String getId() {
            return this.item.getId();
        }

        @Override
        public SplitDirection getSplitDirection() {
            return this.item.getSplitDirection();
        }

        @Override
        public SplitSizePolicy getSizePolicy() {
            return this.item.getSizePolicy();
        }

        @Override
        public float getReferenceChildSize() {
            return this.item.getReferenceChildSize();
        }

        @Override
        public LayoutItemWrapper getFirstChild() {
            return LayoutApplyer.createWrapperFromDefinition(this.item.getFirstChild());
        }

        @Override
        public LayoutItemWrapper getLastChild() {
            return LayoutApplyer.createWrapperFromDefinition(this.item.getLastChild());
        }
    }

    private static class LayoutViewGroupDefinitionWrapper
    implements ViewGroupWrapper {
        private final ViewGroupDefinition item;

        public LayoutViewGroupDefinitionWrapper(ViewGroupDefinition item) {
            this.item = item;
        }

        @Override
        public String getId() {
            return this.item.getId();
        }

        @Override
        public List<String> getViewNames() {
            return this.item.getViews().stream().map(v -> v.getId()).collect(Collectors.toList());
        }

        @Override
        public String getSelectedViewName() {
            return this.item.getSelectedView() != null ? this.item.getSelectedView().getId() : null;
        }

        @Override
        public boolean isPersistent() {
            return this.item.isPersistent();
        }

        @Override
        public ViewGroupPanelState getPanelState() {
            return ViewGroupPanelState.valueOf(this.item.getPanelState().name());
        }
    }
}

