/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.teamapps.dto.AbstractUiDateField;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.SpecialKey;
import org.teamapps.ux.component.field.TextInputHandlingField;
import org.teamapps.ux.session.DateTimeFormatDescriptor;

public abstract class AbstractDateField<VALUE>
extends AbstractField<VALUE>
implements TextInputHandlingField {
    public final Event<String> onTextInput = new Event();
    public final Event<SpecialKey> onSpecialKeyPressed = new Event();
    protected boolean showDropDownButton = true;
    protected boolean showClearButton = false;
    protected boolean favorPastDates = false;
    protected ULocale locale = this.getSessionContext().getULocale();
    protected DateTimeFormatDescriptor dateFormat = this.getSessionContext().getConfiguration().getDateFormat();

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        this.defaultHandleTextInputEvent(event);
    }

    protected void mapAbstractDateFieldUiValues(AbstractUiDateField dateField) {
        this.mapAbstractFieldAttributesToUiField((UiField)dateField);
        dateField.setShowDropDownButton(this.showDropDownButton);
        dateField.setFavorPastDates(this.favorPastDates);
        dateField.setLocale(this.locale.toLanguageTag());
        dateField.setDateFormat(this.dateFormat.toDateTimeFormatDescriptor());
        dateField.setShowClearButton(this.showClearButton);
    }

    public boolean isShowDropDownButton() {
        return this.showDropDownButton;
    }

    public void setShowDropDownButton(boolean showDropDownButton) {
        this.showDropDownButton = showDropDownButton;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetShowDropDownButtonCommand(this.getId(), showDropDownButton));
    }

    public boolean isFavorPastDates() {
        return this.favorPastDates;
    }

    public void setFavorPastDates(boolean favorPastDates) {
        this.favorPastDates = favorPastDates;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetFavorPastDatesCommand(this.getId(), favorPastDates));
    }

    public Locale getLocale() {
        return this.locale.toLocale();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.locale = locale;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetLocaleAndDateFormatCommand(this.getId(), locale.toLanguageTag(), this.dateFormat.toDateTimeFormatDescriptor()));
    }

    public DateTimeFormatDescriptor getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateTimeFormatDescriptor dateFormat) {
        this.dateFormat = dateFormat;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetLocaleAndDateFormatCommand(this.getId(), this.locale.toLanguageTag(), dateFormat.toDateTimeFormatDescriptor()));
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public void setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        this.queueCommandIfRendered(() -> new AbstractUiDateField.SetShowClearButtonCommand(this.getId(), showClearButton));
    }

    @Override
    public Event<String> onTextInput() {
        return this.onTextInput;
    }

    @Override
    public Event<SpecialKey> onSpecialKeyPressed() {
        return this.onSpecialKeyPressed;
    }
}

