/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.coobird.thumbnailator.Thumbnails;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiPictureChooser;
import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.upload.UploadCanceledEventData;
import org.teamapps.ux.component.field.upload.UploadFailedEventData;
import org.teamapps.ux.component.field.upload.UploadStartedEventData;
import org.teamapps.ux.component.field.upload.UploadTooLargeEventData;
import org.teamapps.ux.component.field.upload.UploadedFile;
import org.teamapps.ux.component.field.upload.UploadedFileAccessException;
import org.teamapps.ux.component.flexcontainer.HorizontalLayout;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.imagecropper.ImageCropper;
import org.teamapps.ux.component.imagecropper.ImageCropperSelection;
import org.teamapps.ux.component.imagecropper.ImageCropperSelectionMode;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.css.CssJustifyContent;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.Resource;

public class PictureChooser
extends AbstractField<Resource> {
    public final Event<UploadTooLargeEventData> onUploadTooLarge = new Event();
    public final Event<UploadStartedEventData> onUploadStarted = new Event();
    public final Event<UploadCanceledEventData> onUploadCanceled = new Event();
    public final Event<UploadFailedEventData> onUploadFailed = new Event();
    public final Event<UploadedFile> onUploadSuccessful = new Event();
    private long maxFileSize = 10000000L;
    private String uploadUrl = "/upload";
    private String fileTooLargeMessage;
    private String uploadErrorMessage;
    private Icon browseButtonIcon = MaterialIcon.EDIT;
    private Icon deleteButtonIcon = MaterialIcon.DELETE;
    private int targetImageWidth = 240;
    private int targetImageHeight = 240;
    private int imageDisplayWidth = -1;
    private int imageDisplayHeight = -1;
    private final ImageCropper imageCropper;
    private final Window imageCropperWindow;
    private UploadedFile uploadedFile;
    private final ImageCropperConverter imageCropperConverter = this::cropAndConvertImage;

    public PictureChooser() {
        this.imageCropper = new ImageCropper();
        this.imageCropper.setAspectRatio(Float.valueOf((float)this.targetImageWidth / (float)this.targetImageHeight));
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponentFillRemaining(this.imageCropper);
        Button<BaseTemplateRecord> cancelButton = Button.create(this.getSessionContext().getLocalized(TeamAppsDictionary.CANCEL.getKey(), new Object[0]));
        cancelButton.setCssStyle("margin-right", "5px");
        Button<BaseTemplateRecord> rotateButton = Button.create(this.getSessionContext().getLocalized(TeamAppsDictionary.ROTATE.getKey(), new Object[0]));
        rotateButton.setCssStyle("margin-right", "5px");
        Button<BaseTemplateRecord> okButton = Button.create(this.getSessionContext().getLocalized(TeamAppsDictionary.OK.getKey(), new Object[0]));
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.addComponentAutoSize(cancelButton);
        horizontalLayout.addComponentAutoSize(rotateButton);
        horizontalLayout.addComponentAutoSize(okButton);
        horizontalLayout.setJustifyContent(CssJustifyContent.FLEX_END);
        horizontalLayout.setCssStyle("padding", "5px");
        verticalLayout.addComponentAutoSize(horizontalLayout);
        this.imageCropperWindow = new Window((Icon)MaterialIcon.IMAGE, this.getSessionContext().getLocalized(TeamAppsDictionary.CROP_IMAGE.getKey(), new Object[0]), 700, 500, verticalLayout);
        this.imageCropperWindow.setCloseable(true);
        this.imageCropperWindow.setMaximizable(true);
        this.imageCropperWindow.setModal(true);
        this.imageCropperWindow.setCloseOnEscape(true);
        okButton.onClicked.addListener(() -> {
            try {
                ImageCropperSelection selection = this.imageCropper.getSelection();
                Resource converted = this.imageCropperConverter.convert(this.uploadedFile, selection, this.targetImageWidth, this.targetImageHeight);
                this.setValue(converted);
                this.onValueChanged.fire(converted);
                this.imageCropperWindow.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        rotateButton.onClicked.addListener(() -> {
            try {
                File rotatedImageFile = this.rotateImage(this.uploadedFile.getAsFile());
                this.imageCropper.setImageUrl(this.getSessionContext().createFileLink(rotatedImageFile));
                this.uploadedFile = new UploadedFile(this.uploadedFile.getUuid(), this.uploadedFile.getName(), this.uploadedFile.getSizeInBytes(), this.uploadedFile.getMimeType(), () -> this.createInputStream(rotatedImageFile), () -> rotatedImageFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        cancelButton.onClicked.addListener(() -> this.imageCropperWindow.close());
        this.fileTooLargeMessage = this.getSessionContext().getLocalized(TeamAppsDictionary.FILE_TOO_LARGE_SHORT_MESSAGE.getKey(), new Object[0]);
        this.uploadErrorMessage = this.getSessionContext().getLocalized(TeamAppsDictionary.UPLOAD_ERROR_SHORT_MESSAGE.getKey(), new Object[0]);
    }

    private InputStream createInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object convertUxValueToUiValue(Resource resource) {
        return this.getSessionContext().createResourceLink(resource);
    }

    private Resource cropAndConvertImage(UploadedFile uploadedFile, ImageCropperSelection selection, int targetWidth, int targetHeight) throws IOException {
        File tempFile = Files.createTempFile("cropped-image", ".jpg", new FileAttribute[0]).toFile();
        Thumbnails.of((InputStream[])new InputStream[]{uploadedFile.getAsInputStream()}).sourceRegion(selection.getLeft(), selection.getTop(), selection.getWidth(), selection.getHeight()).size(targetWidth, targetHeight).outputFormat("jpg").toFile(tempFile);
        return new FileResource(tempFile);
    }

    private File rotateImage(File imageFile) throws IOException {
        File newImageFile = File.createTempFile("rotated-image", ".jpg");
        Thumbnails.of((File[])new File[]{imageFile}).scale(1.0).rotate(90.0).toFile(newImageFile);
        return newImageFile;
    }

    public UiField createUiComponent() {
        UiPictureChooser uiField = new UiPictureChooser();
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setUploadUrl(this.uploadUrl);
        uiField.setMaxFileSize(this.maxFileSize);
        uiField.setFileTooLargeMessage(this.fileTooLargeMessage);
        uiField.setUploadErrorMessage(this.uploadErrorMessage);
        uiField.setBrowseButtonIcon(this.getSessionContext().resolveIcon(this.browseButtonIcon));
        uiField.setDeleteButtonIcon(this.getSessionContext().resolveIcon(this.deleteButtonIcon));
        uiField.setImageDisplayWidth(this.imageDisplayWidth != -1 ? this.imageDisplayWidth : this.targetImageWidth);
        uiField.setImageDisplayHeight(this.imageDisplayHeight != -1 ? this.imageDisplayHeight : this.targetImageHeight);
        return uiField;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_PICTURE_CHOOSER_UPLOAD_TOO_LARGE: {
                UiPictureChooser.UploadTooLargeEvent tooLargeEvent = (UiPictureChooser.UploadTooLargeEvent)event;
                this.onUploadTooLarge.fire(new UploadTooLargeEventData(tooLargeEvent.getFileName(), tooLargeEvent.getMimeType(), tooLargeEvent.getSizeInBytes()));
                break;
            }
            case UI_PICTURE_CHOOSER_UPLOAD_STARTED: {
                UiPictureChooser.UploadStartedEvent uploadStartedEvent = (UiPictureChooser.UploadStartedEvent)event;
                this.onUploadStarted.fire(new UploadStartedEventData(uploadStartedEvent.getFileName(), uploadStartedEvent.getMimeType(), uploadStartedEvent.getSizeInBytes()));
                break;
            }
            case UI_PICTURE_CHOOSER_UPLOAD_CANCELED: {
                UiPictureChooser.UploadCanceledEvent canceledEvent = (UiPictureChooser.UploadCanceledEvent)event;
                this.onUploadCanceled.fire(new UploadCanceledEventData(canceledEvent.getFileName(), canceledEvent.getMimeType(), canceledEvent.getSizeInBytes()));
                break;
            }
            case UI_PICTURE_CHOOSER_UPLOAD_FAILED: {
                UiPictureChooser.UploadFailedEvent failedEvent = (UiPictureChooser.UploadFailedEvent)event;
                this.onUploadFailed.fire(new UploadFailedEventData(failedEvent.getFileName(), failedEvent.getMimeType(), failedEvent.getSizeInBytes()));
                break;
            }
            case UI_PICTURE_CHOOSER_UPLOAD_SUCCESSFUL: {
                UiPictureChooser.UploadSuccessfulEvent uploadedEvent = (UiPictureChooser.UploadSuccessfulEvent)event;
                this.uploadedFile = new UploadedFile(uploadedEvent.getUploadedFileUuid(), uploadedEvent.getFileName(), uploadedEvent.getSizeInBytes(), uploadedEvent.getMimeType(), () -> {
                    try {
                        return new FileInputStream(this.getSessionContext().getUploadedFileByUuid(uploadedEvent.getUploadedFileUuid()));
                    }
                    catch (FileNotFoundException e) {
                        throw new UploadedFileAccessException(e);
                    }
                }, () -> this.getSessionContext().getUploadedFileByUuid(uploadedEvent.getUploadedFileUuid()));
                this.onUploadSuccessful.fire(this.uploadedFile);
                this.showImageCropperWindow();
                break;
            }
        }
    }

    public void setImageCropperSelectionMode(ImageCropperSelectionMode selectionMode) {
        this.imageCropper.setSelectionMode(selectionMode);
    }

    private void showImageCropperWindow() {
        this.imageCropper.setImageUrl(this.getSessionContext().createFileLink(this.uploadedFile.getAsFile()));
        this.getSessionContext().showWindow(this.imageCropperWindow, 200);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
        this.queueCommandIfRendered(() -> new UiPictureChooser.SetMaxFileSizeCommand(this.getId(), maxFileSize));
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        this.queueCommandIfRendered(() -> new UiPictureChooser.SetUploadUrlCommand(this.getId(), uploadUrl));
    }

    public String getFileTooLargeMessage() {
        return this.fileTooLargeMessage;
    }

    public void setFileTooLargeMessage(String fileTooLargeMessage) {
        this.fileTooLargeMessage = fileTooLargeMessage;
        this.queueCommandIfRendered(() -> new UiPictureChooser.SetFileTooLargeMessageCommand(this.getId(), fileTooLargeMessage));
    }

    public String getUploadErrorMessage() {
        return this.uploadErrorMessage;
    }

    public void setUploadErrorMessage(String uploadErrorMessage) {
        this.uploadErrorMessage = uploadErrorMessage;
        this.queueCommandIfRendered(() -> new UiPictureChooser.SetUploadErrorMessageCommand(this.getId(), uploadErrorMessage));
    }

    public Icon getBrowseButtonIcon() {
        return this.browseButtonIcon;
    }

    public void setBrowseButtonIcon(Icon browseButtonIcon) {
        this.browseButtonIcon = browseButtonIcon;
    }

    public Icon getDeleteButtonIcon() {
        return this.deleteButtonIcon;
    }

    public void setDeleteButtonIcon(Icon deleteButtonIcon) {
        this.deleteButtonIcon = deleteButtonIcon;
    }

    public int getTargetImageWidth() {
        return this.targetImageWidth;
    }

    public void setTargetImageWidth(int targetImageWidth) {
        this.targetImageWidth = targetImageWidth;
        this.imageCropper.setAspectRatio(Float.valueOf((float)targetImageWidth / (float)this.targetImageHeight));
    }

    public int getTargetImageHeight() {
        return this.targetImageHeight;
    }

    public void setTargetImageHeight(int targetImageHeight) {
        this.targetImageHeight = targetImageHeight;
        this.imageCropper.setAspectRatio(Float.valueOf((float)this.targetImageWidth / (float)targetImageHeight));
    }

    public void setTargetImageSize(int width, int height) {
        this.targetImageWidth = width;
        this.targetImageHeight = height;
        this.imageCropper.setAspectRatio(Float.valueOf((float)width / (float)height));
    }

    public int getImageDisplayWidth() {
        return this.imageDisplayWidth;
    }

    public void setImageDisplayWidth(int imageDisplayWidth) {
        this.imageDisplayWidth = imageDisplayWidth;
    }

    public int getImageDisplayHeight() {
        return this.imageDisplayHeight;
    }

    public void setImageDisplayHeight(int imageDisplayHeight) {
        this.imageDisplayHeight = imageDisplayHeight;
    }

    public void setImageDisplaySize(int imageDisplayWidth, int imageDisplayHeight) {
        this.imageDisplayWidth = imageDisplayWidth;
        this.imageDisplayHeight = imageDisplayHeight;
    }

    public static interface ImageCropperConverter {
        public Resource convert(UploadedFile var1, ImageCropperSelection var2, int var3, int var4) throws IOException;
    }
}

