/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiComboBoxTreeRecord;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiTree;
import org.teamapps.dto.UiTreeRecord;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.field.combobox.TemplateDecider;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.model.TreeModel;
import org.teamapps.ux.model.TreeModelChangedEventData;

public class Tree<RECORD>
extends AbstractComponent {
    private final Logger LOGGER = LoggerFactory.getLogger(Tree.class);
    public final Event<RECORD> onNodeSelected = new Event();
    public final Event<String> onTextInput = new Event();
    private TreeModel<RECORD> model;
    private PropertyProvider<RECORD> propertyProvider = new BeanPropertyExtractor();
    private RECORD selectedNode;
    private Template entryTemplate = null;
    private TemplateDecider<RECORD> templateDecider = record -> this.entryTemplate;
    private final Map<Template, String> templateIdsByTemplate = new HashMap<Template, String>();
    private int templateIdCounter = 0;
    private int indentation = 15;
    private boolean animated = true;
    private boolean showExpanders = true;
    private boolean openOnSelection = false;
    private boolean enforceSingleExpandedPath = false;
    private Function<RECORD, String> recordToStringFunction = Object::toString;
    private int clientRecordIdCounter = 0;
    private final Map<RECORD, UiTreeRecord> uiRecordsByRecord = new HashMap<RECORD, UiTreeRecord>();
    private final Runnable modelAllNodesChangedListener = () -> {
        if (this.isRendered()) {
            this.uiRecordsByRecord.clear();
            List<UiTreeRecord> uiRecords = this.createOrUpdateUiRecords(this.model.getRecords());
            this.getSessionContext().queueCommand(new UiTree.ReplaceDataCommand(this.getId(), uiRecords));
        }
    };
    private final Consumer<TreeModelChangedEventData<RECORD>> modelChangedListener = changedEventData -> {
        if (this.isRendered()) {
            List removedUiIds = changedEventData.getRemovedNodes().stream().map(key -> this.uiRecordsByRecord.remove(key).getId()).collect(Collectors.toList());
            List<UiTreeRecord> addedOrUpdatedUiTreeRecords = this.createOrUpdateUiRecords(changedEventData.getAddedOrUpdatedNodes());
            this.getSessionContext().queueCommand(new UiTree.BulkUpdateCommand(this.getId(), removedUiIds, addedOrUpdatedUiTreeRecords));
        }
    };

    public Tree(TreeModel<RECORD> model) {
        this.model = model;
        this.registerModelListeners();
    }

    private void registerModelListeners() {
        this.model.onAllNodesChanged().addListener(this.modelAllNodesChangedListener);
        this.model.onChanged().addListener(this.modelChangedListener);
    }

    private void unregisterMutableTreeModelListeners() {
        this.model.onAllNodesChanged().removeListener(this.modelAllNodesChangedListener);
        this.model.onChanged().removeListener(this.modelChangedListener);
    }

    protected List<UiTreeRecord> createOrUpdateUiRecords(List<RECORD> records) {
        if (records == null) {
            return Collections.emptyList();
        }
        ArrayList<UiTreeRecord> uiRecords = new ArrayList<UiTreeRecord>();
        for (RECORD record : records) {
            UiTreeRecord uiRecord = this.createUiTreeRecordWithoutParentRelation(record);
            this.uiRecordsByRecord.put(record, uiRecord);
            uiRecords.add(uiRecord);
        }
        for (RECORD record : records) {
            this.addParentLinkToUiRecord(record, this.uiRecordsByRecord.get(record));
        }
        return uiRecords;
    }

    protected UiTreeRecord createUiTreeRecordWithoutParentRelation(RECORD record) {
        UiComboBoxTreeRecord uiTreeRecord;
        if (record == null) {
            return null;
        }
        Template template = this.getTemplateForRecord(record);
        List<String> dataKeys = template != null ? template.getDataKeys() : Collections.emptyList();
        Map<String, Object> values = this.propertyProvider.getValues(record, dataKeys);
        if (this.uiRecordsByRecord.containsKey(record)) {
            uiTreeRecord = this.uiRecordsByRecord.get(record);
        } else {
            uiTreeRecord = new UiComboBoxTreeRecord();
            uiTreeRecord.setId(++this.clientRecordIdCounter);
        }
        uiTreeRecord.setValues(values);
        uiTreeRecord.setDisplayTemplateId(this.templateIdsByTemplate.get(template));
        uiTreeRecord.setAsString(this.recordToStringFunction.apply(record));
        TreeNodeInfo treeNodeInfo = this.model.getTreeNodeInfo(record);
        if (treeNodeInfo != null) {
            uiTreeRecord.setExpanded(treeNodeInfo.isExpanded());
            uiTreeRecord.setLazyChildren(treeNodeInfo.isLazyChildren());
        }
        return uiTreeRecord;
    }

    protected void addParentLinkToUiRecord(RECORD record, UiTreeRecord uiTreeRecord) {
        UiTreeRecord uiParent;
        Object parent;
        TreeNodeInfo treeNodeInfo = this.model.getTreeNodeInfo(record);
        if (treeNodeInfo != null && (parent = treeNodeInfo.getParent()) != null && (uiParent = this.uiRecordsByRecord.get(parent)) != null) {
            uiTreeRecord.setParentId(Integer.valueOf(uiParent.getId()));
        }
    }

    private Template getTemplateForRecord(RECORD record) {
        Template template;
        Template templateFromDecider = this.templateDecider.getTemplate(record);
        Template template2 = template = templateFromDecider != null ? templateFromDecider : this.entryTemplate;
        if (template != null && !this.templateIdsByTemplate.containsKey(template)) {
            String uuid = "" + this.templateIdCounter++;
            this.templateIdsByTemplate.put(template, uuid);
            this.queueCommandIfRendered(() -> new UiTree.RegisterTemplateCommand(this.getId(), uuid, template.createUiTemplate()));
        }
        return template;
    }

    @Override
    public UiComponent createUiComponent() {
        UiTree uiTree = new UiTree();
        this.mapAbstractUiComponentProperties((UiComponent)uiTree);
        List<RECORD> records = this.model.getRecords();
        if (records != null) {
            uiTree.setInitialData(this.createOrUpdateUiRecords(records));
        }
        if (this.selectedNode != null) {
            uiTree.setSelectedNodeId(Integer.valueOf(this.uiRecordsByRecord.get(this.selectedNode).getId()));
        }
        uiTree.setTemplates(this.templateIdsByTemplate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((Template)entry.getKey()).createUiTemplate())));
        uiTree.setDefaultTemplateId(this.templateIdsByTemplate.get(this.entryTemplate));
        uiTree.setAnimate(this.animated);
        uiTree.setShowExpanders(this.showExpanders);
        uiTree.setOpenOnSelection(this.openOnSelection);
        uiTree.setEnforceSingleExpandedPath(this.enforceSingleExpandedPath);
        uiTree.setIndentation(this.indentation);
        return uiTree;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TREE_NODE_SELECTED: {
                UiTree.NodeSelectedEvent nodeSelectedEvent = (UiTree.NodeSelectedEvent)event;
                RECORD record = this.getRecordByUiId(nodeSelectedEvent.getNodeId());
                this.selectedNode = record;
                if (record == null) break;
                this.onNodeSelected.fire(record);
                break;
            }
            case UI_TREE_REQUEST_TREE_DATA: {
                UiTree.RequestTreeDataEvent requestTreeDataEvent = (UiTree.RequestTreeDataEvent)event;
                RECORD parentNode = this.getRecordByUiId(requestTreeDataEvent.getParentNodeId());
                if (parentNode == null) break;
                List<RECORD> children = this.model.getChildRecords(parentNode);
                List<UiTreeRecord> uiChildren = this.createOrUpdateUiRecords(children);
                if (!this.isRendered()) break;
                this.getSessionContext().queueCommand(new UiTree.BulkUpdateCommand(this.getId(), Collections.emptyList(), uiChildren));
            }
        }
    }

    public RECORD getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(RECORD selectedNode) {
        int uiRecordId = this.uiRecordsByRecord.get(selectedNode) != null ? this.uiRecordsByRecord.get(selectedNode).getId() : -1;
        this.selectedNode = selectedNode;
        this.queueCommandIfRendered(() -> new UiTree.SetSelectedNodeCommand(this.getId(), Integer.valueOf(uiRecordId)));
    }

    public TreeModel<RECORD> getModel() {
        return this.model;
    }

    public void setModel(TreeModel<RECORD> model) {
        this.unregisterMutableTreeModelListeners();
        this.model = model;
        this.registerModelListeners();
        this.refresh();
    }

    private void refresh() {
        this.modelAllNodesChangedListener.run();
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
        this.reRenderIfRendered();
    }

    public boolean isShowExpanders() {
        return this.showExpanders;
    }

    public void setShowExpanders(boolean showExpanders) {
        this.showExpanders = showExpanders;
        this.reRenderIfRendered();
    }

    public boolean isOpenOnSelection() {
        return this.openOnSelection;
    }

    public void setOpenOnSelection(boolean openOnSelection) {
        this.openOnSelection = openOnSelection;
        this.reRenderIfRendered();
    }

    public boolean isEnforceSingleExpandedPath() {
        return this.enforceSingleExpandedPath;
    }

    public void setEnforceSingleExpandedPath(boolean enforceSingleExpandedPath) {
        this.enforceSingleExpandedPath = enforceSingleExpandedPath;
        this.reRenderIfRendered();
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
        this.reRenderIfRendered();
    }

    public PropertyProvider<RECORD> getPropertyProvider() {
        return this.propertyProvider;
    }

    public void setPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.setPropertyProvider(propertyExtractor);
    }

    public Template getEntryTemplate() {
        return this.entryTemplate;
    }

    public void setEntryTemplate(Template entryTemplate) {
        this.entryTemplate = entryTemplate;
        this.reRenderIfRendered();
    }

    public TemplateDecider<RECORD> getTemplateDecider() {
        return this.templateDecider;
    }

    public void setTemplateDecider(TemplateDecider<RECORD> templateDecider) {
        this.templateDecider = templateDecider;
        this.reRenderIfRendered();
    }

    public Function<RECORD, String> getRecordToStringFunction() {
        return this.recordToStringFunction;
    }

    public void setRecordToStringFunction(Function<RECORD, String> recordToStringFunction) {
        this.recordToStringFunction = recordToStringFunction;
        this.reRenderIfRendered();
    }

    private RECORD getRecordByUiId(int uiRecordId) {
        return this.uiRecordsByRecord.keySet().stream().filter(rr -> this.uiRecordsByRecord.get(rr).getId() == uiRecordId).findFirst().orElse(null);
    }
}

