/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc.apiclient;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.component.webrtc.apiclient.MediaKind;
import org.teamapps.ux.component.webrtc.apiclient.StreamFileRequest;

public interface MediaSoupV3ApiClient {
    public static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public CompletableFuture<Double> getWorkerLoad(int var1);

    public CompletableFuture<Integer> getNumberOfWorkers();

    public CompletableFuture<Void> startRecording(int var1, String var2);

    public CompletableFuture<Void> startRecording(int var1, String var2, Set<MediaKind> var3);

    public CompletableFuture<Void> stopRecording(int var1, String var2);

    default public CompletableFuture<Void> setRecordingEnabled(int workerId, String streamUuid, boolean enabled) {
        return enabled ? this.startRecording(workerId, streamUuid) : this.stopRecording(workerId, streamUuid);
    }

    public CompletableFuture<Void> startFileStreaming(int var1, StreamFileRequest var2);

    public CompletableFuture<Void> stopFileStreaming(int var1, String var2);

    public CompletableFuture<List<String>> getRecordedStreamUuids();

    public CompletableFuture<List<String>> getStreamRecordingsForUuid(String var1);

    public CompletableFuture<Void> deleteStreamRecordings(String var1);

    public CompletableFuture<Void> deleteRecording(String var1);

    public static File downloadVideo(URL url, File downloadDirectory) throws IOException {
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            LOGGER.info("Downloading video: {} to {}", (Object)url, (Object)downloadDirectory.getAbsolutePath());
            File resultFile = new File(downloadDirectory, FilenameUtils.getName((String)url.getPath()).replace(':', '-'));
            try (BufferedInputStream is = new BufferedInputStream(con.getInputStream());
                 BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(resultFile, false));){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            File file = resultFile;
            return file;
        }
        catch (IOException e) {
            LOGGER.error("Exception while downloading video: " + url, (Throwable)e);
            throw e;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static File downloadVideo(String url) throws IOException {
        return MediaSoupV3ApiClient.downloadVideo(new URL(url), Files.createTempDirectory("download", new FileAttribute[0]).toFile());
    }
}

