/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiColorPicker;
import org.teamapps.dto.UiField;
import org.teamapps.ux.component.field.AbstractField;

public class ColorPicker
extends AbstractField<Color> {
    private Color defaultColor = new RgbaColor(0, 0, 0);
    private String saveButtonCaption = "Save";
    private String clearButtonCaption = "Clear";

    public UiField createUiComponent() {
        UiColorPicker uiColorPicker = new UiColorPicker();
        this.mapAbstractFieldAttributesToUiField((UiField)uiColorPicker);
        uiColorPicker.setDefaultColor(this.defaultColor != null ? this.defaultColor.toHtmlColorString() : null);
        uiColorPicker.setSaveButtonCaption(this.saveButtonCaption);
        uiColorPicker.setClearButtonCaption(this.clearButtonCaption);
        return uiColorPicker;
    }

    @Override
    public Color convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        return Color.fromHtmlString((String)((String)value));
    }

    @Override
    public Object convertUxValueToUiValue(Color color) {
        return color != null ? color.toHtmlColorString() : null;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public String getSaveButtonCaption() {
        return this.saveButtonCaption;
    }

    public void setSaveButtonCaption(String saveButtonCaption) {
        this.saveButtonCaption = saveButtonCaption;
    }

    public String getClearButtonCaption() {
        return this.clearButtonCaption;
    }

    public void setClearButtonCaption(String clearButtonCaption) {
        this.clearButtonCaption = clearButtonCaption;
    }
}

