/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.flexcontainer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiFlexContainer;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.flexcontainer.FlexSizingPolicy;
import org.teamapps.ux.css.CssAlignItems;
import org.teamapps.ux.css.CssFlexDirection;
import org.teamapps.ux.css.CssJustifyContent;

public class FlexContainer
extends AbstractComponent {
    private List<Component> components = new ArrayList<Component>();
    private CssFlexDirection flexDirection = CssFlexDirection.ROW;
    private CssAlignItems alignItems = CssAlignItems.STRETCH;
    private CssJustifyContent justifyContent = CssJustifyContent.FLEX_START;

    public UiFlexContainer createUiComponent() {
        UiFlexContainer uiFlexContainer = new UiFlexContainer();
        this.mapAbstractUiComponentProperties((UiComponent)uiFlexContainer);
        uiFlexContainer.setComponents(this.components.stream().map(c -> c.createUiReference()).collect(Collectors.toList()));
        uiFlexContainer.setFlexDirection(this.flexDirection.toUiCssFlexDirection());
        uiFlexContainer.setAlignItems(this.alignItems.toCssAlignItems());
        uiFlexContainer.setJustifyContent(this.justifyContent.toUiCssJustifyContent());
        return uiFlexContainer;
    }

    public void addComponent(Component component) {
        this.components.add(component);
        this.queueCommandIfRendered(() -> new UiFlexContainer.AddComponentCommand(this.getId(), component.createUiReference()));
    }

    public void addComponent(Component component, FlexSizingPolicy sizingPolicy) {
        component.setCssStyle("flex", sizingPolicy.toCssValue());
        this.addComponent(component);
    }

    public void removeComponent(Component component) {
        this.components.remove(component);
        this.queueCommandIfRendered(() -> new UiFlexContainer.RemoveComponentCommand(this.getId(), component.createUiReference()));
    }

    public void removeAllComponents() {
        this.components.forEach(c -> this.queueCommandIfRendered(() -> new UiFlexContainer.RemoveComponentCommand(this.getId(), c.createUiReference())));
        this.components.clear();
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    public CssFlexDirection getFlexDirection() {
        return this.flexDirection;
    }

    public void setFlexDirection(CssFlexDirection flexDirection) {
        this.flexDirection = flexDirection;
        this.reRenderIfRendered();
    }

    public CssAlignItems getAlignItems() {
        return this.alignItems;
    }

    public void setAlignItems(CssAlignItems alignItems) {
        this.alignItems = alignItems;
        this.reRenderIfRendered();
    }

    public CssJustifyContent getJustifyContent() {
        return this.justifyContent;
    }

    public void setJustifyContent(CssJustifyContent justifyContent) {
        this.justifyContent = justifyContent;
        this.reRenderIfRendered();
    }

    public List<Component> getComponents() {
        return Collections.unmodifiableList(this.components);
    }
}

