/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiRootPanel;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.icons.SessionIconProvider;
import org.teamapps.server.UxServerContext;
import org.teamapps.uisession.ClientBackPressureInfo;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.UiCommandExecutor;
import org.teamapps.uisession.UiCommandWithResultCallback;
import org.teamapps.uisession.UiSessionActivityState;
import org.teamapps.util.MultiKeySequentialExecutor;
import org.teamapps.util.NamedThreadFactory;
import org.teamapps.ux.component.ClientObject;
import org.teamapps.ux.component.animation.EntranceAnimation;
import org.teamapps.ux.component.animation.ExitAnimation;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.linkbutton.LinkButton;
import org.teamapps.ux.component.notification.Notification;
import org.teamapps.ux.component.notification.NotificationPosition;
import org.teamapps.ux.component.popup.Popup;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.component.rootpanel.WakeLock;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.template.TemplateReference;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.i18n.RankingTranslationProvider;
import org.teamapps.ux.i18n.TeamAppsTranslationProviderFactory;
import org.teamapps.ux.i18n.TranslationProvider;
import org.teamapps.ux.icon.IconBundle;
import org.teamapps.ux.icon.TeamAppsIconBundle;
import org.teamapps.ux.json.UxJacksonSerializationTemplate;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.ClientSessionResourceProvider;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.ExecutionDecorator;
import org.teamapps.ux.session.ExecutionDecoratorStack;
import org.teamapps.ux.session.SessionConfiguration;

public class SessionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionContext.class);
    private static final MultiKeySequentialExecutor<SessionContext> sessionMultiKeyExecutor = new MultiKeySequentialExecutor(new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() / 2 + 1, 1000, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("teamapps-session-executor", true)));
    public final Event<UiSessionActivityState> onActivityStateChanged = new Event();
    public final Event<Void> onDestroyed = new Event();
    public final ExecutionDecoratorStack executionDecorators = new ExecutionDecoratorStack();
    private boolean active = true;
    private volatile boolean destroyed = false;
    private final QualifiedUiSessionId sessionId;
    private final ClientInfo clientInfo;
    private final HttpSession httpSession;
    private final UiCommandExecutor commandExecutor;
    private final UxServerContext serverContext;
    private final SessionIconProvider iconProvider;
    private final UxJacksonSerializationTemplate uxJacksonSerializationTemplate;
    private final HashMap<String, ClientObject> clientObjectsById = new HashMap();
    private final ClientSessionResourceProvider sessionResourceProvider;
    private final RankingTranslationProvider rankingTranslationProvider;
    private final Map<String, Template> registeredTemplates = new ConcurrentHashMap<String, Template>();
    private SessionConfiguration sessionConfiguration;
    private final Map<String, Icon<?, ?>> bundleIconByKey = new HashMap();
    private Window sessionExpiredWindow;
    private Window sessionErrorWindow;
    private Window sessionTerminatedWindow;

    public SessionContext(QualifiedUiSessionId sessionId, ClientInfo clientInfo, SessionConfiguration sessionConfiguration, HttpSession httpSession, UiCommandExecutor commandExecutor, UxServerContext serverContext, SessionIconProvider iconProvider, ObjectMapper jacksonObjectMapper) {
        this.sessionId = sessionId;
        this.httpSession = httpSession;
        this.clientInfo = clientInfo;
        this.sessionConfiguration = sessionConfiguration;
        this.commandExecutor = commandExecutor;
        this.serverContext = serverContext;
        this.iconProvider = iconProvider;
        this.sessionResourceProvider = new ClientSessionResourceProvider(sessionId);
        this.uxJacksonSerializationTemplate = new UxJacksonSerializationTemplate(jacksonObjectMapper, this);
        this.rankingTranslationProvider = new RankingTranslationProvider();
        this.rankingTranslationProvider.addTranslationProvider(TeamAppsTranslationProviderFactory.createProvider());
        this.addIconBundle(TeamAppsIconBundle.createBundle());
        this.runWithContext(this::updateSessionMessageWindows);
    }

    public static SessionContext current() {
        return CurrentSessionContext.get();
    }

    public static SessionContext currentOrNull() {
        return CurrentSessionContext.getOrNull();
    }

    public void addTranslationProvider(TranslationProvider translationProvider) {
        this.rankingTranslationProvider.addTranslationProvider(translationProvider);
    }

    public void addIconBundle(IconBundle iconBundle) {
        iconBundle.getEntries().forEach(entry -> this.bundleIconByKey.put(entry.getKey(), entry.getIcon()));
    }

    public Icon<?, ?> getIcon(String key) {
        return this.bundleIconByKey.get(key);
    }

    public ULocale getULocale() {
        return this.sessionConfiguration.getULocale();
    }

    public Locale getLocale() {
        return this.sessionConfiguration.getLocale();
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.sessionConfiguration.setULocale(locale);
        this.setConfiguration(this.sessionConfiguration);
    }

    public String getLocalized(String key, Object ... parameters) {
        String value = this.rankingTranslationProvider.getTranslation(key, Arrays.asList(this.getLocale(), Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN));
        if (parameters != null) {
            return MessageFormat.format(value, parameters);
        }
        return value;
    }

    public boolean isActive() {
        return this.active;
    }

    public void handleActivityStateChangedInternal(boolean active) {
        this.active = active;
        this.onActivityStateChanged.fire(new UiSessionActivityState(active));
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        this.commandExecutor.closeSession(this.sessionId, UiSessionClosingReason.TERMINATED_BY_APPLICATION);
    }

    public void handleSessionDestroyedInternal() {
        this.onDestroyed.fireIgnoringExceptions(null);
        this.runWithContext(() -> {
            this.destroyed = true;
            sessionMultiKeyExecutor.closeForKey(this);
        }, true);
    }

    public Event<Void> onDestroyed() {
        return this.onDestroyed;
    }

    public <RESULT> void queueCommand(UiCommand<RESULT> command, Consumer<RESULT> resultCallback) {
        if (CurrentSessionContext.get() != this) {
            String errorMessage = "Trying to queue a command for foreign/null SessionContext (CurrentSessionContext.get() != this). Please use SessionContext.runWithContext(Runnable). NOTE: The command will not get queued!";
            LOGGER.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        Consumer<Object> wrappedCallback = resultCallback != null ? result -> this.runWithContext(() -> resultCallback.accept(result)) : null;
        this.uxJacksonSerializationTemplate.doWithUxJacksonSerializers(() -> this.commandExecutor.sendCommand(this.sessionId, new UiCommandWithResultCallback(command, wrappedCallback)));
    }

    public <RESULT> void queueCommand(UiCommand<RESULT> command) {
        this.queueCommand(command, null);
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    @Deprecated
    public void flushCommands() {
    }

    public ClientBackPressureInfo getClientBackPressureInfo() {
        return this.commandExecutor.getClientBackPressureInfo(this.sessionId);
    }

    public String createFileLink(File file) {
        return this.sessionResourceProvider.createFileLink(file);
    }

    public String createResourceLink(Resource resource, String uniqueIdentifier) {
        return this.sessionResourceProvider.createResourceLink(resource, uniqueIdentifier);
    }

    public Resource getBinaryResource(int resourceId) {
        return this.sessionResourceProvider.getBinaryResource(resourceId);
    }

    public File getUploadedFileByUuid(String uuid) {
        return this.serverContext.getUploadedFileByUuid(uuid);
    }

    public TemplateReference registerTemplate(String id, Template template) {
        this.registeredTemplates.put(id, template);
        this.queueCommand((UiCommand)new UiRootPanel.RegisterTemplateCommand(id, template.createUiTemplate()));
        return new TemplateReference(template, id);
    }

    public void registerTemplates(Map<String, Template> templates) {
        this.registeredTemplates.putAll(templates);
        this.queueCommand((UiCommand)new UiRootPanel.RegisterTemplatesCommand(templates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Template)entry.getValue()).createUiTemplate()))));
    }

    public Template getTemplate(String id) {
        return this.registeredTemplates.get(id);
    }

    public CompletableFuture<Void> runWithContext(Runnable runnable) {
        return this.runWithContext(runnable, false);
    }

    public CompletableFuture<Void> runWithContext(Runnable runnable, boolean forceEnqueue) {
        if (this.destroyed) {
            LOGGER.info("This SessionContext ({}) is already destroyed. Not sending command.", (Object)this.sessionId);
            return CompletableFuture.failedFuture(new IllegalStateException("SessionContext destroyed."));
        }
        if (CurrentSessionContext.getOrNull() == this && !forceEnqueue) {
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }
        return sessionMultiKeyExecutor.submit(this, () -> {
            CurrentSessionContext.set(this);
            try {
                this.executionDecorators.createWrappedRunnable(runnable).run();
            }
            finally {
                CurrentSessionContext.unset();
            }
        });
    }

    public void addExecutionDecorator(ExecutionDecorator decorator, boolean outer) {
        if (outer) {
            this.executionDecorators.addOuterDecorator(decorator);
        } else {
            this.executionDecorators.addInnerDecorator(decorator);
        }
    }

    public SessionConfiguration getConfiguration() {
        return this.sessionConfiguration;
    }

    public void setConfiguration(SessionConfiguration config) {
        this.sessionConfiguration = config;
        this.queueCommand((UiCommand)new UiRootPanel.SetConfigCommand(config.createUiConfiguration()));
        this.updateSessionMessageWindows();
    }

    public void showPopupAtCurrentMousePosition(Popup popup) {
        this.queueCommand((UiCommand)new UiRootPanel.ShowPopupAtCurrentMousePositionCommand(popup.createUiReference()));
    }

    public void showPopup(Popup popup) {
        this.queueCommand((UiCommand)new UiRootPanel.ShowPopupCommand(popup.createUiReference()));
    }

    public ZoneId getTimeZone() {
        return this.sessionConfiguration.getTimeZone();
    }

    public SessionIconProvider getIconProvider() {
        return this.iconProvider;
    }

    public <I extends Icon<I, S>, S> void setDefaultStyleForIconClass(Class<I> iconClass, S defaultStyle) {
        this.runWithContext(() -> this.iconProvider.setDefaultStyleForIconClass(iconClass, defaultStyle));
    }

    public String resolveIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        return this.sessionConfiguration.getIconPath() + "/" + this.iconProvider.encodeIcon(icon, true);
    }

    public void registerClientObject(ClientObject clientObject) {
        this.clientObjectsById.put(clientObject.getId(), clientObject);
    }

    public void unregisterClientObject(ClientObject clientObject) {
        this.clientObjectsById.remove(clientObject.getId());
    }

    public ClientObject getClientObject(String clientObjectId) {
        return this.clientObjectsById.get(clientObjectId);
    }

    public String createResourceLink(Resource resource) {
        return this.createResourceLink(resource, null);
    }

    public void showWindow(Window window, int animationDuration) {
        window.show(animationDuration);
    }

    public void downloadFile(String fileUrl, String downloadFileName) {
        this.runWithContext(() -> this.queueCommand((UiCommand)new UiRootPanel.DownloadFileCommand(fileUrl, downloadFileName)));
    }

    public void downloadFile(File file, String downloadFileName) {
        this.runWithContext(() -> this.queueCommand((UiCommand)new UiRootPanel.DownloadFileCommand(this.createFileLink(file), downloadFileName)));
    }

    public void registerBackgroundImage(String id, String image, String blurredImage) {
        this.queueCommand((UiCommand)new UiRootPanel.RegisterBackgroundImageCommand(id, image, blurredImage));
    }

    public void setBackgroundImage(String id, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.SetBackgroundImageCommand(id, animationDuration));
    }

    public void setBackgroundColor(Color color, int animationDuration) {
        this.queueCommand((UiCommand)new UiRootPanel.SetBackgroundColorCommand(color != null ? color.toHtmlColorString() : null, animationDuration));
    }

    public void exitFullScreen() {
        this.queueCommand((UiCommand)new UiRootPanel.ExitFullScreenCommand());
    }

    @Deprecated
    public void addRootComponent(String containerElementId, RootPanel rootPanel) {
        this.addRootPanel(containerElementId, rootPanel);
    }

    public void addRootPanel(String containerElementId, RootPanel rootPanel) {
        this.queueCommand((UiCommand)new UiRootPanel.BuildRootPanelCommand(containerElementId, rootPanel.createUiReference()));
    }

    public RootPanel addRootPanel(String containerElementId) {
        RootPanel rootPanel = new RootPanel();
        this.addRootPanel(containerElementId, rootPanel);
        return rootPanel;
    }

    public RootPanel addRootPanel() {
        return this.addRootPanel(null);
    }

    public void addClientToken(String token) {
        this.queueCommand((UiCommand)new UiRootPanel.AddClientTokenCommand(token));
    }

    public void removeClientToken(String token) {
        this.queueCommand((UiCommand)new UiRootPanel.RemoveClientTokenCommand(token));
    }

    public void clearClientTokens() {
        this.queueCommand((UiCommand)new UiRootPanel.ClearClientTokensCommand());
    }

    public void showNotification(Notification notification, NotificationPosition position, EntranceAnimation entranceAnimation, ExitAnimation exitAnimation) {
        this.runWithContext(() -> this.queueCommand((UiCommand)new UiRootPanel.ShowNotificationCommand(notification.createUiReference(), position.toUiNotificationPosition(), entranceAnimation.toUiEntranceAnimation(), exitAnimation.toUiExitAnimation())));
    }

    public void showNotification(Notification notification, NotificationPosition position) {
        this.runWithContext(() -> this.showNotification(notification, position, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT));
    }

    public void showNotification(Icon icon, String caption) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndCaption(icon, caption);
            notification.setDismissible(true);
            notification.setShowProgressBar(false);
            notification.setDisplayTimeInMillis(5000);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }

    public void showNotification(Icon icon, String caption, String description) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndTextAndDescription(icon, caption, description);
            notification.setDismissible(true);
            notification.setShowProgressBar(false);
            notification.setDisplayTimeInMillis(5000);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }

    public void showNotification(Icon icon, String caption, String description, boolean dismissable, int displayTimeInMillis, boolean showProgress) {
        this.runWithContext(() -> {
            Notification notification = Notification.createWithIconAndTextAndDescription(icon, caption, description);
            notification.setDismissible(dismissable);
            notification.setDisplayTimeInMillis(displayTimeInMillis);
            notification.setShowProgressBar(showProgress);
            this.showNotification(notification, NotificationPosition.TOP_RIGHT, EntranceAnimation.SLIDE_IN_RIGHT, ExitAnimation.FADE_OUT);
        });
    }

    public void setSessionExpiredWindow(Window sessionExpiredWindow) {
        this.sessionExpiredWindow = sessionExpiredWindow;
        this.updateSessionMessageWindows();
    }

    public void setSessionErrorWindow(Window sessionErrorWindow) {
        this.sessionErrorWindow = sessionErrorWindow;
        this.updateSessionMessageWindows();
    }

    public void setSessionTerminatedWindow(Window sessionTerminatedWindow) {
        this.sessionTerminatedWindow = sessionTerminatedWindow;
        this.updateSessionMessageWindows();
    }

    private void updateSessionMessageWindows() {
        this.queueCommand((UiCommand)new UiRootPanel.SetSessionMessageWindowsCommand(this.sessionExpiredWindow != null ? this.sessionExpiredWindow.createUiReference() : SessionContext.createDefaultSessionMessageWindow(this.getLocalized("teamapps.common.sessionExpired", new Object[0]), this.getLocalized("teamapps.common.sessionExpiredText", new Object[0]), this.getLocalized("teamapps.common.refresh", new Object[0]), this.getLocalized("teamapps.common.cancel", new Object[0])).createUiReference(), this.sessionErrorWindow != null ? this.sessionErrorWindow.createUiReference() : SessionContext.createDefaultSessionMessageWindow(this.getLocalized("teamapps.common.error", new Object[0]), this.getLocalized("teamapps.common.sessionErrorText", new Object[0]), this.getLocalized("teamapps.common.refresh", new Object[0]), this.getLocalized("teamapps.common.cancel", new Object[0])).createUiReference(), this.sessionTerminatedWindow != null ? this.sessionTerminatedWindow.createUiReference() : SessionContext.createDefaultSessionMessageWindow(this.getLocalized("teamapps.common.sessionTerminated", new Object[0]), this.getLocalized("teamapps.common.sessionTerminatedText", new Object[0]), this.getLocalized("teamapps.common.refresh", new Object[0]), this.getLocalized("teamapps.common.cancel", new Object[0])).createUiReference()));
    }

    public static Window createDefaultSessionMessageWindow(String title, String message, String refreshButtonCaption, String cancelButtonCaption) {
        Window window = new Window(null, title, null, 300, 300, false, false, false);
        window.setPadding(10);
        VerticalLayout verticalLayout = new VerticalLayout();
        DisplayField messageField = new DisplayField(false, false);
        messageField.setCssStyle("font-size", "110%");
        messageField.setValue(message);
        verticalLayout.addComponentFillRemaining(messageField);
        Button<String> refreshButton = new Button<String>(null, refreshButtonCaption);
        refreshButton.setCssStyle("margin", "10px 0");
        refreshButton.setCssStyle(".UiButton", "background-color", RgbaColor.MATERIAL_BLUE_600.toHtmlColorString());
        refreshButton.setCssStyle(".UiButton", "color", RgbaColor.WHITE.toHtmlColorString());
        refreshButton.setCssStyle(".UiButton", "font-size", "120%");
        refreshButton.setCssStyle(".UiButton", "height", "50px");
        refreshButton.setOnClickJavaScript("window.location.reload()");
        verticalLayout.addComponentAutoSize(refreshButton);
        if (cancelButtonCaption != null) {
            LinkButton cancelLink = new LinkButton(cancelButtonCaption);
            cancelLink.setCssStyle("text-align", "center");
            cancelLink.setOnClickJavaScript("context.getClientObjectById(\"" + window.createUiReference().getId() + "\").close();");
            verticalLayout.addComponentAutoSize(cancelLink);
        }
        window.setContent(verticalLayout);
        return window;
    }

    public CompletableFuture<WakeLock> requestWakeLock() {
        String uuid = UUID.randomUUID().toString();
        CompletableFuture<WakeLock> completableFuture = new CompletableFuture<WakeLock>();
        this.runWithContext(() -> this.queueCommand((UiCommand)new UiRootPanel.RequestWakeLockCommand(uuid), (Consumer)successful -> {
            if (successful.booleanValue()) {
                completableFuture.complete(() -> this.queueCommand((UiCommand)new UiRootPanel.ReleaseWakeLockCommand(uuid)));
            } else {
                completableFuture.completeExceptionally(new RuntimeException("Could not acquire WakeLock"));
            }
        }));
        return completableFuture;
    }
}

