/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.calendar;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.teamapps.ux.component.calendar.CalendarViewMode;

public class ViewChangedEventData {
    private final ZoneId zoneId;
    private final CalendarViewMode viewMode;
    private final Instant mainIntervalStart;
    private final Instant mainIntervalEnd;
    private final Instant displayedIntervalStart;
    private final Instant displayedIntervalEnd;

    public ViewChangedEventData(ZoneId zoneId, CalendarViewMode viewMode, Instant mainIntervalStart, Instant mainIntervalEnd, Instant displayedIntervalStart, Instant displayedIntervalEnd) {
        this.zoneId = zoneId;
        this.viewMode = viewMode;
        this.mainIntervalStart = mainIntervalStart;
        this.mainIntervalEnd = mainIntervalEnd;
        this.displayedIntervalStart = displayedIntervalStart;
        this.displayedIntervalEnd = displayedIntervalEnd;
    }

    public LocalDate getMainIntervalStartAsLocalDate() {
        return ZonedDateTime.ofInstant(this.mainIntervalStart, this.zoneId).toLocalDate();
    }

    public LocalDate getMainIntervalEndAsLocalDate() {
        return ZonedDateTime.ofInstant(this.mainIntervalEnd, this.zoneId).toLocalDate();
    }

    public LocalDate getDisplayedIntervalStartAsLocalDate() {
        return ZonedDateTime.ofInstant(this.displayedIntervalStart, this.zoneId).toLocalDate();
    }

    public LocalDate getDisplayedIntervalEndAsLocalDate() {
        return ZonedDateTime.ofInstant(this.displayedIntervalEnd, this.zoneId).toLocalDate();
    }

    public CalendarViewMode getViewMode() {
        return this.viewMode;
    }

    public Instant getMainIntervalStart() {
        return this.mainIntervalStart;
    }

    public Instant getMainIntervalEnd() {
        return this.mainIntervalEnd;
    }

    public Instant getDisplayedIntervalStart() {
        return this.displayedIntervalStart;
    }

    public Instant getDisplayedIntervalEnd() {
        return this.displayedIntervalEnd;
    }
}

