/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc.apiclient;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.component.webrtc.apiclient.FilePathInput;
import org.teamapps.ux.component.webrtc.apiclient.MediaKind;
import org.teamapps.ux.component.webrtc.apiclient.MediaSoupV3ApiAction;
import org.teamapps.ux.component.webrtc.apiclient.MediaSoupV3ApiClient;
import org.teamapps.ux.component.webrtc.apiclient.MediaSoupV3ApiClientException;
import org.teamapps.ux.component.webrtc.apiclient.MediaSoupV3TokenGenerator;
import org.teamapps.ux.component.webrtc.apiclient.RequestMetadata;
import org.teamapps.ux.component.webrtc.apiclient.StatsInput;
import org.teamapps.ux.component.webrtc.apiclient.StreamAndKinds;
import org.teamapps.ux.component.webrtc.apiclient.StreamData;
import org.teamapps.ux.component.webrtc.apiclient.StreamFileRequest;

public class MediaSoupV3SocketIoApiClient
implements MediaSoupV3ApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Socket socket;
    private final String serverSecret;

    public MediaSoupV3SocketIoApiClient(String serverUrl, String serverSecret) {
        this.socket = this.createSocket(serverUrl);
        this.serverSecret = serverSecret;
        this.socket.connect();
    }

    public CompletableFuture<JsonNode> getServerConfigs() {
        String token = MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.GET_SERVER_CONFIGS, token, null, new TypeReference<JsonNode>(){});
    }

    public CompletableFuture<JsonNode> producersStats(StatsInput statsInput) {
        String token = MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.PRODUCERS_STATS, token, statsInput, new TypeReference<JsonNode>(){});
    }

    public CompletableFuture<JsonNode> consumersStats(StatsInput statsInput) {
        String token = MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.CONSUMERS_STATS, token, statsInput, new TypeReference<JsonNode>(){});
    }

    public CompletableFuture<JsonNode> transportStats(List<String> ids) {
        String token = MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.TRANSPORT_STATS, token, new StatsInput(ids), new TypeReference<JsonNode>(){});
    }

    @Override
    public CompletableFuture<Double> getWorkerLoad(int workerId) {
        String token = MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(workerId, MediaSoupV3ApiAction.WORKER_LOAD, token, null, new TypeReference<JsonNode>(){}).thenApply(treeNode -> (Double)OBJECT_MAPPER.convertValue((Object)treeNode.get("currentLoad"), Double.class));
    }

    @Override
    public CompletableFuture<Integer> getNumberOfWorkers() {
        String token = MediaSoupV3TokenGenerator.generateGeneralApiToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.NUM_WORKERS, token, null, new TypeReference<JsonNode>(){}).thenApply(treeNode -> (Integer)OBJECT_MAPPER.convertValue((Object)treeNode.get("num"), Integer.class));
    }

    @Override
    public CompletableFuture<Void> startRecording(String streamUuid) {
        return this.startRecording(streamUuid, null);
    }

    @Override
    public CompletableFuture<Void> startRecording(String streamUuid, Set<MediaKind> kinds) {
        String token = MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.START_RECORDING, token, new StreamAndKinds(streamUuid, kinds), new TypeReference<Void>(){});
    }

    @Override
    public CompletableFuture<Void> stopRecording(String streamUuid) {
        String token = MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.STOP_RECORDING, token, new StreamAndKinds(streamUuid, Set.of(MediaKind.AUDIO, MediaKind.VIDEO)), new TypeReference<Void>(){});
    }

    @Override
    public CompletableFuture<Void> startFileStreaming(int workerId, StreamFileRequest streamFileRequest) {
        String token = MediaSoupV3TokenGenerator.generateStreamingJwtToken(streamFileRequest.getStreamUuid(), this.serverSecret, Duration.ofDays(365L));
        return this.call(workerId, MediaSoupV3ApiAction.FILE_STREAMING, token, streamFileRequest, new TypeReference<Void>(){});
    }

    @Override
    public CompletableFuture<Void> stopFileStreaming(int workerId, String streamUuid) {
        String token = MediaSoupV3TokenGenerator.generateStreamingJwtToken(streamUuid, this.serverSecret, Duration.ofDays(365L));
        return this.call(workerId, MediaSoupV3ApiAction.STOP_FILE_STREAMING, token, new StreamData(streamUuid), new TypeReference<Void>(){});
    }

    @Override
    public CompletableFuture<List<String>> getRecordedStreamUuids() {
        String token = MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.RECORDED_STREAMS, token, null, new TypeReference<JsonNode>(){}).thenApply(treeNode -> (List)OBJECT_MAPPER.convertValue((Object)treeNode.get("list"), (TypeReference)new TypeReference<List<String>>(){}));
    }

    @Override
    public CompletableFuture<List<String>> getStreamRecordingsForUuid(String streamUuid) {
        String token = MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.STREAM_RECORDINGS, token, new StreamData(streamUuid), new TypeReference<JsonNode>(){}).thenApply(treeNode -> (List)OBJECT_MAPPER.convertValue((Object)treeNode.get("list"), (TypeReference)new TypeReference<List<String>>(){}));
    }

    @Override
    public CompletableFuture<Void> deleteStreamRecordings(String streamUuid) {
        String token = MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.DELETE_STREAM_RECORDINGS, token, new StreamData(streamUuid), new TypeReference<Void>(){});
    }

    @Override
    public CompletableFuture<Void> deleteRecording(String recordingName) {
        String token = MediaSoupV3TokenGenerator.generateRecordingJwtToken(this.serverSecret, Duration.ofDays(365L));
        return this.call(0, MediaSoupV3ApiAction.DELETE_RECORDING, token, new FilePathInput(recordingName), new TypeReference<Void>(){});
    }

    public <R> CompletableFuture<R> call(int worker, MediaSoupV3ApiAction action, String token, Object parametersObject, TypeReference<R> responseType) {
        String metadataJson;
        String paramsJson;
        try {
            paramsJson = OBJECT_MAPPER.writeValueAsString(parametersObject);
            metadataJson = OBJECT_MAPPER.writeValueAsString((Object)new RequestMetadata(worker, token));
        }
        catch (JsonProcessingException e) {
            return CompletableFuture.failedFuture(e);
        }
        CompletableFuture future = new CompletableFuture();
        this.socket.emit(action.getName(), new Object[]{paramsJson, metadataJson}, responsePayload -> {
            LOGGER.info("Got response from mediasoup: " + responsePayload[0]);
            if (responsePayload[0] == null) {
                future.complete(null);
            } else {
                JsonNode jsonNode = MediaSoupV3SocketIoApiClient.parseJson(responsePayload[0].toString());
                if (jsonNode.get("errorId") != null) {
                    future.completeExceptionally(new MediaSoupV3ApiClientException("Error while calling " + action.getName() + "! Code: " + jsonNode.get("errorId")));
                } else {
                    try {
                        future.complete(OBJECT_MAPPER.readValue(responsePayload[0].toString(), responseType));
                    }
                    catch (JsonProcessingException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    public void close() {
        this.socket.close();
    }

    private Socket createSocket(String serverUrl) {
        Socket socket;
        try {
            socket = IO.socket((String)serverUrl);
        }
        catch (URISyntaxException e) {
            throw new MediaSoupV3ApiClientException(e);
        }
        socket.on("connect", args13 -> LOGGER.info("EVENT_CONNECT: {}", (Object)Arrays.toString(args13))).on("connecting", args13 -> LOGGER.info("EVENT_CONNECTING: {}", (Object)Arrays.toString(args13))).on("disconnect", args13 -> LOGGER.info("EVENT_DISCONNECT: {}", (Object)Arrays.toString(args13))).on("error", args13 -> LOGGER.error("EVENT_ERROR: {}", (Object)Arrays.toString(args13))).on("message", args13 -> LOGGER.info("EVENT_MESSAGE: {}", (Object)Arrays.toString(args13))).on("connect_error", args13 -> LOGGER.info("EVENT_CONNECT_ERROR: {}", (Object)Arrays.toString(args13))).on("connect_timeout", args13 -> LOGGER.info("EVENT_CONNECT_TIMEOUT: {}", (Object)Arrays.toString(args13))).on("reconnect", args13 -> LOGGER.info("EVENT_RECONNECT: {}", (Object)Arrays.toString(args13))).on("reconnect_error", args13 -> LOGGER.info("EVENT_RECONNECT_ERROR: {}", (Object)Arrays.toString(args13))).on("reconnect_failed", args13 -> LOGGER.info("EVENT_RECONNECT_FAILED: {}", (Object)Arrays.toString(args13))).on("reconnect_attempt", args13 -> LOGGER.info("EVENT_RECONNECT_ATTEMPT: {}", (Object)Arrays.toString(args13))).on("reconnecting", args13 -> LOGGER.info("EVENT_RECONNECTING: {}", (Object)Arrays.toString(args13)));
        return socket;
    }

    private static JsonNode parseJson(Object o) {
        if (o == null) {
            return NullNode.getInstance();
        }
        try {
            return OBJECT_MAPPER.readTree((String)o);
        }
        catch (JsonProcessingException e) {
            return NullNode.getInstance();
        }
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

