/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.teamapps.ux.i18n.TeamAppsResourceBundleControl;
import org.teamapps.ux.i18n.TranslationProvider;

public class ResourceBundleTranslationProvider
implements TranslationProvider {
    private final List<Locale> languages;
    private final List<String> keys;
    private final Map<Locale, PropertyResourceBundle> resourceBundleByLocale = new HashMap<Locale, PropertyResourceBundle>();

    public ResourceBundleTranslationProvider(String baseName, Locale ... languages) {
        this(baseName, "properties", languages);
    }

    public ResourceBundleTranslationProvider(String baseName, String resourceFileSuffix, Locale ... languages) {
        this(baseName, resourceFileSuffix, Arrays.asList(languages), Locale.getDefault());
    }

    public ResourceBundleTranslationProvider(String baseName, String resourceFileSuffix, List<Locale> languages, Locale fallbackLocale) {
        this.languages = languages;
        HashSet<String> allKeys = new HashSet<String>();
        for (Locale language : languages) {
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, language, new TeamAppsResourceBundleControl(resourceFileSuffix, fallbackLocale));
            if (!(bundle instanceof PropertyResourceBundle)) continue;
            PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)bundle;
            this.resourceBundleByLocale.put(language, propertyResourceBundle);
            allKeys.addAll(propertyResourceBundle.keySet());
        }
        this.keys = new ArrayList<String>(allKeys);
    }

    @Override
    public List<Locale> getLanguages() {
        return this.languages;
    }

    @Override
    public List<String> getKeys() {
        return this.keys;
    }

    @Override
    public String getTranslation(String key, Locale locale) {
        PropertyResourceBundle propertyResourceBundle = this.resourceBundleByLocale.get(locale);
        if (propertyResourceBundle == null) {
            return null;
        }
        Object value = propertyResourceBundle.handleGetObject(key);
        if (value != null) {
            return (String)value;
        }
        return null;
    }
}

