/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.combobox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.UiComboBox;
import org.teamapps.dto.UiComboBoxTreeRecord;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiTagComboBox;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.component.field.combobox.AbstractComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.component.tree.TreeNodeInfoExtractor;
import org.teamapps.ux.model.ComboBoxModel;

public class TagComboBox<RECORD>
extends AbstractComboBox<TagComboBox, RECORD, List<RECORD>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagComboBox.class);
    public final Event<String> onFreeTextEntered = new Event();
    public final Event<String> onFreeTextRemoved = new Event();
    private int maxEntries;
    private TagBoxWrappingMode wrappingMode = TagBoxWrappingMode.MULTI_LINE;
    private boolean distinct = false;
    private List<String> freeTextEntries = new ArrayList<String>();

    public TagComboBox() {
        this.init();
    }

    public TagComboBox(Template template) {
        this.setTemplate(template);
        this.init();
    }

    public TagComboBox(ComboBoxModel<RECORD> model) {
        super(model);
        this.init();
    }

    private void init() {
        this.recordCache.setPurgeDecider((record, clientId) -> this.getValue() == null || !((List)this.getValue()).contains(record));
    }

    public static <R> TagComboBox<R> createForList(List<R> staticData) {
        return TagComboBox.createForList(staticData, (Template)null);
    }

    public static <R> TagComboBox<R> createForList(List<R> staticData, Template template) {
        TagComboBox comboBox = new TagComboBox(template);
        comboBox.setModel(query -> staticData.stream().filter(record -> comboBox.getRecordToStringFunction().apply(record).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList()));
        return comboBox;
    }

    public static <R> TagComboBox<R> createForList(final List<R> staticData, final TreeNodeInfoExtractor<R> treeNodeInfoExtractor) {
        final TagComboBox comboBox = new TagComboBox();
        comboBox.setModel(new ComboBoxModel<R>(){

            @Override
            public List<R> getRecords(String query) {
                return staticData.stream().filter(record -> comboBox.getRecordToStringFunction().apply(record).toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
            }

            @Override
            public TreeNodeInfo getTreeNodeInfo(R r) {
                return treeNodeInfoExtractor.getTreeNodeInfo(r);
            }
        });
        return comboBox;
    }

    public static <ENUM extends Enum> TagComboBox<ENUM> createForEnum(Class<ENUM> enumClass) {
        TagComboBox<Enum> tagComboBox = TagComboBox.createForList(Arrays.asList((Enum[])enumClass.getEnumConstants()));
        tagComboBox.setShowClearButton(true);
        return tagComboBox;
    }

    public UiField createUiComponent() {
        UiTagComboBox comboBox = new UiTagComboBox();
        this.mapCommonUiComboBoxProperties((UiComboBox)comboBox);
        comboBox.setMaxEntries(this.maxEntries);
        comboBox.setWrappingMode(this.wrappingMode.toUiWrappingMode());
        comboBox.setDistinct(this.distinct);
        return comboBox;
    }

    @Override
    public void setValue(List<RECORD> records) {
        super.setValue(records);
        this.freeTextEntries.clear();
    }

    @Override
    public List<RECORD> convertUiValueToUxValue(Object value) {
        if (value != null && !(value instanceof List)) {
            throw new IllegalArgumentException("Invalid TagComboBox value coming from ui: " + value);
        }
        if (value == null) {
            value = Collections.emptyList();
        }
        List uiValues = value;
        ArrayList records = new ArrayList();
        ArrayList<String> uiFreeTextEntries = new ArrayList<String>();
        for (Object entry : uiValues) {
            if (entry instanceof Integer) {
                Object recordFromSelectedRecordCache = this.recordCache.getRecordByClientId((Integer)entry);
                if (recordFromSelectedRecordCache == null) {
                    LOGGER.error("Could not find record in client record cache: " + entry);
                    continue;
                }
                records.add(recordFromSelectedRecordCache);
                continue;
            }
            uiFreeTextEntries.add("" + entry);
        }
        List<String> newFreeTextEntries = uiFreeTextEntries.stream().filter(uiFreeTextEntry -> !this.freeTextEntries.contains(uiFreeTextEntry)).collect(Collectors.toList());
        List<String> removedFreeTextEntries = this.freeTextEntries.stream().filter(existingFreeTextEntry -> !uiFreeTextEntries.contains(existingFreeTextEntry)).collect(Collectors.toList());
        if (!newFreeTextEntries.isEmpty()) {
            newFreeTextEntries.forEach(newFreeText -> {
                if (this.freeTextRecordFactory != null) {
                    Object record = this.freeTextRecordFactory.apply(newFreeText);
                    CacheManipulationHandle cacheResponse = this.recordCache.addRecord(record);
                    records.add(record);
                    if (this.isRendered()) {
                        this.getSessionContext().queueCommand(new UiComboBox.ReplaceFreeTextEntryCommand(this.getId(), newFreeText, (UiComboBoxTreeRecord)cacheResponse.getAndClearResult()), aVoid -> cacheResponse.commit());
                    } else {
                        cacheResponse.commit();
                    }
                    uiFreeTextEntries.remove(newFreeText);
                } else {
                    this.onFreeTextEntered.fire((String)newFreeText);
                }
            });
            this.freeTextEntries = uiFreeTextEntries;
        }
        if (removedFreeTextEntries.size() > 0) {
            removedFreeTextEntries.forEach(removedEntryText -> this.onFreeTextRemoved.fire((String)removedFreeTextEntries.get(0)));
            this.freeTextEntries = uiFreeTextEntries;
        }
        this.recordCache.replaceRecords(records).commit();
        return records;
    }

    @Override
    public Object convertUxValueToUiValue(List<RECORD> uxValue) {
        if (uxValue == null) {
            return null;
        }
        CacheManipulationHandle cacheResponse = this.recordCache.addRecords(uxValue);
        cacheResponse.commit();
        return cacheResponse.getAndClearResult();
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        this.reRenderIfRendered();
    }

    public TagBoxWrappingMode getWrappingMode() {
        return this.wrappingMode;
    }

    public void setWrappingMode(TagBoxWrappingMode wrappingMode) {
        this.wrappingMode = wrappingMode;
        this.reRenderIfRendered();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
        this.reRenderIfRendered();
    }

    public List<String> getFreeTextEntries() {
        return this.freeTextEntries;
    }

    public void setFreeTextEntries(List<String> freeTextEntries) {
        this.freeTextEntries = freeTextEntries;
    }
}

