/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.grid.layout;

import org.teamapps.dto.UiGridColumn;
import org.teamapps.ux.component.format.SizingPolicy;

public class GridColumn {
    private SizingPolicy widthPolicy;
    private int leftPadding;
    private int rightPadding;

    public GridColumn() {
        this.widthPolicy = SizingPolicy.AUTO;
    }

    public GridColumn(SizingPolicy widthPolicy) {
        this.widthPolicy = widthPolicy;
    }

    public GridColumn(SizingPolicy widthPolicy, int leftPadding, int rightPadding) {
        this.widthPolicy = widthPolicy;
        this.leftPadding = leftPadding;
        this.rightPadding = rightPadding;
    }

    public GridColumn(GridColumn gridColumn) {
        this(gridColumn.widthPolicy, gridColumn.leftPadding, gridColumn.rightPadding);
    }

    public SizingPolicy getWidthPolicy() {
        return this.widthPolicy;
    }

    public GridColumn setWidthPolicy(SizingPolicy widthPolicy) {
        this.widthPolicy = widthPolicy;
        return this;
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }

    public GridColumn setLeftPadding(int leftPadding) {
        this.leftPadding = leftPadding;
        return this;
    }

    public int getRightPadding() {
        return this.rightPadding;
    }

    public GridColumn setRightPadding(int rightPadding) {
        this.rightPadding = rightPadding;
        return this;
    }

    public UiGridColumn createUiGridColumn() {
        return new UiGridColumn().setWidthPolicy(this.widthPolicy != null ? this.widthPolicy.createUiSizingPolicy() : null).setLeftPadding(this.leftPadding).setRightPadding(this.rightPadding);
    }
}

