/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.Objects;
import org.teamapps.dto.UiLongInterval;

public class Interval {
    private final long min;
    private final long max;

    public Interval(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public static Interval union(Interval interval, Interval intervalB) {
        return new Interval(Math.min(interval.getMin(), intervalB.getMin()), Math.max(interval.getMax(), intervalB.getMax()));
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public UiLongInterval createUiLongInterval() {
        return new UiLongInterval(this.min, this.max);
    }

    public String toString() {
        return "Interval{min=" + this.min + ", max=" + this.max + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return this.min == interval.min && this.max == interval.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

