/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.validator;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.teamapps.ux.component.field.FieldMessage;

public interface FieldValidator<VALUE> {
    public List<FieldMessage> validate(VALUE var1);

    public static <VALUE> FieldValidator<VALUE> fromPredicate(Predicate<VALUE> validationPredicate, String errorMessage) {
        return value -> validationPredicate.test(value) ? Collections.emptyList() : Collections.singletonList(new FieldMessage(FieldMessage.Severity.ERROR, errorMessage));
    }

    public static <VALUE> FieldValidator<VALUE> fromErrorMessageFunction(Function<VALUE, String> errorMessageOrNullFunction) {
        return value -> {
            String errorMessage = (String)errorMessageOrNullFunction.apply(value);
            return errorMessage == null ? Collections.emptyList() : Collections.singletonList(new FieldMessage(FieldMessage.Severity.ERROR, errorMessage));
        };
    }
}

