/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiClientRecord;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiTemplateField;
import org.teamapps.event.Event;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.template.Template;

public class TemplateField<RECORD>
extends AbstractField<RECORD> {
    public final Event<Void> onClicked = new Event();
    private Template template;
    private PropertyProvider<RECORD> propertyProvider = new BeanPropertyExtractor();

    public TemplateField(Template template) {
        this.template = template;
    }

    public TemplateField(Template template, RECORD value) {
        this.template = template;
        this.setValue(value);
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_TEMPLATE_FIELD_CLICKED: {
                this.onClicked.fire();
            }
        }
    }

    public UiTemplateField createUiComponent() {
        UiTemplateField ui = new UiTemplateField();
        this.mapAbstractFieldAttributesToUiField((UiField)ui);
        ui.setTemplate(this.template.createUiTemplate());
        ui.setValue((Object)this.createUiRecord(this.getValue()));
        return ui;
    }

    @Override
    public RECORD convertUiValueToUxValue(Object value) {
        return (RECORD)this.getValue();
    }

    @Override
    public Object convertUxValueToUiValue(RECORD record) {
        if (record == null) {
            return null;
        }
        return this.createUiRecord(record);
    }

    private UiClientRecord createUiRecord(RECORD record) {
        if (record == null) {
            return null;
        }
        UiClientRecord uiClientRecord = new UiClientRecord();
        uiClientRecord.setValues(this.propertyProvider.getValues(record, this.template.getDataKeys()));
        return uiClientRecord;
    }

    public Template getTemplate() {
        return this.template;
    }

    public TemplateField<RECORD> setTemplate(Template template) {
        this.template = template;
        this.queueCommandIfRendered(() -> new UiTemplateField.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public PropertyProvider<RECORD> getPropertyProvider() {
        return this.propertyProvider;
    }

    public TemplateField<RECORD> setPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.propertyProvider = propertyProvider;
        this.queueCommandIfRendered(() -> new UiTemplateField.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public TemplateField<RECORD> setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        return this.setPropertyProvider(propertyExtractor);
    }
}

