/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import org.teamapps.dto.UiDateTimeFormatDescriptor;
import org.teamapps.dto.UiFullLongMediumShortType;
import org.teamapps.dto.UiHourCycleType;
import org.teamapps.dto.UiLongShortNarrowType;
import org.teamapps.dto.UiNumericOrLongShortNarrowType;
import org.teamapps.dto.UiNumericType;

public class DateTimeFormatDescriptor {
    private final FullLongMediumShortType dateStyle;
    private final FullLongMediumShortType timeStyle;
    private final Integer fractionalSecondDigits;
    private final Boolean dayPeriod;
    private final HourCycleType hourCycle;
    private final LongShortNarrowType weekday;
    private final LongShortNarrowType era;
    private final NumericType year;
    private final NumericOrLongShortNarrowType month;
    private final NumericType day;
    private final NumericType hour;
    private final NumericType minute;
    private final NumericType second;

    public static Builder builer() {
        return new Builder();
    }

    public static DateTimeFormatDescriptor forDate(FullLongMediumShortType dateStyle) {
        return new DateTimeFormatDescriptor(dateStyle, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static DateTimeFormatDescriptor forTime(FullLongMediumShortType timeStyle) {
        return new DateTimeFormatDescriptor(null, timeStyle, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static DateTimeFormatDescriptor forTime(FullLongMediumShortType timeStyle, HourCycleType hourCycle) {
        return new DateTimeFormatDescriptor(null, timeStyle, null, null, hourCycle, null, null, null, null, null, null, null, null);
    }

    private DateTimeFormatDescriptor(FullLongMediumShortType dateStyle, FullLongMediumShortType timeStyle, Integer fractionalSecondDigits, Boolean dayPeriod, HourCycleType hourCycle, LongShortNarrowType weekday, LongShortNarrowType era, NumericType year, NumericOrLongShortNarrowType month, NumericType day, NumericType hour, NumericType minute, NumericType second) {
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.fractionalSecondDigits = fractionalSecondDigits;
        this.dayPeriod = dayPeriod;
        this.hourCycle = hourCycle;
        this.weekday = weekday;
        this.era = era;
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public UiDateTimeFormatDescriptor toDateTimeFormatDescriptor() {
        UiDateTimeFormatDescriptor ui = new UiDateTimeFormatDescriptor();
        ui.setDateStyle(this.dateStyle != null ? this.dateStyle.toUiValue() : null);
        ui.setTimeStyle(this.timeStyle != null ? this.timeStyle.toUiValue() : null);
        ui.setFractionalSecondDigits(this.fractionalSecondDigits == null || this.fractionalSecondDigits == 0 ? null : this.fractionalSecondDigits);
        ui.setDayPeriod(this.dayPeriod);
        ui.setHourCycle(this.hourCycle != null ? this.hourCycle.toUiValue() : null);
        ui.setWeekday(this.weekday != null ? this.weekday.toUiValue() : null);
        ui.setEra(this.era != null ? this.era.toUiValue() : null);
        ui.setYear(this.year != null ? this.year.toUiValue() : null);
        ui.setMonth(this.month != null ? this.month.toUiValue() : null);
        ui.setDay(this.day != null ? this.day.toUiValue() : null);
        ui.setHour(this.hour != null ? this.hour.toUiValue() : null);
        ui.setMinute(this.minute != null ? this.minute.toUiValue() : null);
        ui.setSecond(this.second != null ? this.second.toUiValue() : null);
        return ui;
    }

    public FullLongMediumShortType getDateStyle() {
        return this.dateStyle;
    }

    public FullLongMediumShortType getTimeStyle() {
        return this.timeStyle;
    }

    public Boolean getDayPeriod() {
        return this.dayPeriod;
    }

    public Integer getFractionalSecondDigits() {
        return this.fractionalSecondDigits;
    }

    public Boolean isDayPeriod() {
        return this.dayPeriod;
    }

    public HourCycleType getHourCycle() {
        return this.hourCycle;
    }

    public LongShortNarrowType getWeekday() {
        return this.weekday;
    }

    public LongShortNarrowType getEra() {
        return this.era;
    }

    public NumericType getYear() {
        return this.year;
    }

    public NumericOrLongShortNarrowType getMonth() {
        return this.month;
    }

    public NumericType getDay() {
        return this.day;
    }

    public NumericType getHour() {
        return this.hour;
    }

    public NumericType getMinute() {
        return this.minute;
    }

    public NumericType getSecond() {
        return this.second;
    }

    public static class Builder {
        private Integer fractionalSecondDigits;
        private Boolean dayPeriod;
        private HourCycleType hourCycle;
        private LongShortNarrowType weekday;
        private LongShortNarrowType era;
        private NumericType year;
        private NumericOrLongShortNarrowType month;
        private NumericType day;
        private NumericType hour;
        private NumericType minute;
        private NumericType second;

        public Builder setFractionalSecondDigits(Integer fractionalSecondDigits) {
            this.fractionalSecondDigits = fractionalSecondDigits;
            return this;
        }

        public Builder setDayPeriod(Boolean dayPeriod) {
            this.dayPeriod = dayPeriod;
            return this;
        }

        public Builder setHourCycle(HourCycleType hourCycle) {
            this.hourCycle = hourCycle;
            return this;
        }

        public Builder setWeekday(LongShortNarrowType weekday) {
            this.weekday = weekday;
            return this;
        }

        public Builder setEra(LongShortNarrowType era) {
            this.era = era;
            return this;
        }

        public Builder setYear(NumericType year) {
            this.year = year;
            return this;
        }

        public Builder setMonth(NumericOrLongShortNarrowType month) {
            this.month = month;
            return this;
        }

        public Builder setDay(NumericType day) {
            this.day = day;
            return this;
        }

        public Builder setHour(NumericType hour) {
            this.hour = hour;
            return this;
        }

        public Builder setMinute(NumericType minute) {
            this.minute = minute;
            return this;
        }

        public Builder setSecond(NumericType second) {
            this.second = second;
            return this;
        }

        public DateTimeFormatDescriptor build() {
            return new DateTimeFormatDescriptor(null, null, this.fractionalSecondDigits, this.dayPeriod, this.hourCycle, this.weekday, this.era, this.year, this.month, this.day, this.hour, this.minute, this.second);
        }
    }

    public static enum FullLongMediumShortType {
        FULL("full"),
        LONG("long"),
        MEDIUM("medium"),
        SHORT("short");

        private final String jsLiteral;

        private FullLongMediumShortType(String jsLiteral) {
            this.jsLiteral = jsLiteral;
        }

        public String getJsLiteral() {
            return this.jsLiteral;
        }

        public UiFullLongMediumShortType toUiValue() {
            return UiFullLongMediumShortType.valueOf((String)this.name());
        }
    }

    public static enum HourCycleType {
        H11("h11"),
        H12("h12"),
        H23("h23"),
        H24("h24");

        private final String jsLiteral;

        private HourCycleType(String jsLiteral) {
            this.jsLiteral = jsLiteral;
        }

        public String getJsLiteral() {
            return this.jsLiteral;
        }

        public UiHourCycleType toUiValue() {
            return UiHourCycleType.valueOf((String)this.name());
        }
    }

    public static enum LongShortNarrowType {
        LONG("long"),
        SHORT("short"),
        NARROW("narrow");

        private final String jsLiteral;

        private LongShortNarrowType(String jsLiteral) {
            this.jsLiteral = jsLiteral;
        }

        public String getJsLiteral() {
            return this.jsLiteral;
        }

        public UiLongShortNarrowType toUiValue() {
            return UiLongShortNarrowType.valueOf((String)this.name());
        }
    }

    public static enum NumericType {
        NUMERIC("numeric"),
        TWO_DIGIT("2-digit");

        private final String jsLiteral;

        private NumericType(String jsLiteral) {
            this.jsLiteral = jsLiteral;
        }

        public String getJsLiteral() {
            return this.jsLiteral;
        }

        public UiNumericType toUiValue() {
            return UiNumericType.valueOf((String)this.name());
        }
    }

    public static enum NumericOrLongShortNarrowType {
        NUMERIC("numeric"),
        TWO_DIGIT("2-digit"),
        LONG("long"),
        SHORT("short"),
        NARROW("narrow");

        private final String jsLiteral;

        private NumericOrLongShortNarrowType(String jsLiteral) {
            this.jsLiteral = jsLiteral;
        }

        public String getJsLiteral() {
            return this.jsLiteral;
        }

        public UiNumericOrLongShortNarrowType toUiValue() {
            return UiNumericOrLongShortNarrowType.valueOf((String)this.name());
        }
    }
}

