/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.calendar;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiCalendar;
import org.teamapps.dto.UiCalendarEventClientRecord;
import org.teamapps.dto.UiCalendarEventRenderingStyle;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiWeekDay;
import org.teamapps.event.Event;
import org.teamapps.event.EventListener;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.calendar.CalendarEvent;
import org.teamapps.ux.component.calendar.CalendarModel;
import org.teamapps.ux.component.calendar.CalendarViewMode;
import org.teamapps.ux.component.calendar.DayClickedEventData;
import org.teamapps.ux.component.calendar.EventClickedEventData;
import org.teamapps.ux.component.calendar.EventMovedEventData;
import org.teamapps.ux.component.calendar.ViewChangedEventData;
import org.teamapps.ux.component.field.combobox.TemplateDecider;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class Calendar<RECORD>
extends AbstractComponent {
    private final Logger LOGGER = LoggerFactory.getLogger(Calendar.class);
    public final Event<EventClickedEventData<RECORD>> onEventClicked = new Event();
    public final Event<EventMovedEventData<RECORD>> onEventMoved = new Event();
    public final Event<DayClickedEventData> onDayClicked = new Event();
    public final Event<ViewChangedEventData> onViewChanged = new Event();
    private CalendarModel<RECORD> model;
    private PropertyExtractor<RECORD> propertyExtractor = new BeanPropertyExtractor();
    ClientRecordCache<CalendarEvent<RECORD>, UiCalendarEventClientRecord> recordCache = new ClientRecordCache<CalendarEvent, UiCalendarEventClientRecord>(this::createUiCalendarEventClientRecord);
    private Template dayViewTemplate = null;
    private TemplateDecider<CalendarEvent<RECORD>> dayViewTemplateDecider = record -> this.dayViewTemplate;
    private Template monthViewTemplate = null;
    private TemplateDecider<CalendarEvent<RECORD>> monthViewTemplateDecider = record -> this.monthViewTemplate;
    private int templateIdCounter = 0;
    private final Map<Template, String> templateIdsByTemplate = new HashMap<Template, String>();
    private CalendarViewMode activeViewMode = CalendarViewMode.MONTH;
    private LocalDate displayedDate = LocalDate.now();
    private boolean showHeader = false;
    private boolean tableBorder = false;
    private boolean showWeekNumbers = true;
    private int businessHoursStart = 8;
    private int businessHoursEnd = 17;
    private DayOfWeek firstDayOfWeek = DayOfWeek.MONDAY;
    private List<DayOfWeek> workingDays = Arrays.asList(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    private Color tableHeaderBackgroundColor;
    private Color defaultBackgroundColor = new Color(154, 204, 228);
    private Color defaultBorderColor = new Color(154, 204, 228);
    private EventListener<Void> onCalendarDataChangedListener = aVoid -> this.refreshEvents();

    public Calendar() {
        this(null);
    }

    public Calendar(CalendarModel<RECORD> model) {
        if (model != null) {
            this.setModel(model);
        }
    }

    private UiCalendarEventClientRecord createUiCalendarEventClientRecord(CalendarEvent<RECORD> calendarEvent) {
        Template template = this.getTemplateForRecord(calendarEvent);
        Map values = template != null ? this.propertyExtractor.getValues(calendarEvent.getRecord(), template.getDataKeys()) : Collections.emptyMap();
        UiCalendarEventClientRecord uiRecord = new UiCalendarEventClientRecord();
        uiRecord.setValues(values);
        uiRecord.setTemplateId(this.templateIdsByTemplate.get(template));
        uiRecord.setStart(calendarEvent.getStartAsLong());
        uiRecord.setEnd(calendarEvent.getEndAsLong());
        uiRecord.setAsString(template == null && calendarEvent.getRecord() != null ? calendarEvent.getRecord().toString() : null);
        uiRecord.setAllDay(calendarEvent.isAllDay());
        uiRecord.setAllowDragOperations(calendarEvent.isAllowDragOperations());
        uiRecord.setBackgroundColor(calendarEvent.getBackgroundColor() != null ? UiUtil.createUiColor(calendarEvent.getBackgroundColor()) : null);
        uiRecord.setBorderColor(calendarEvent.getBorderColor() != null ? UiUtil.createUiColor(calendarEvent.getBorderColor()) : null);
        uiRecord.setRendering(calendarEvent.getRendering() != null ? calendarEvent.getRendering().toUiCalendarEventRenderingStyle() : UiCalendarEventRenderingStyle.DEFAULT);
        return uiRecord;
    }

    private Template getTemplateForRecord(CalendarEvent<RECORD> record) {
        Template template;
        if (this.activeViewMode == CalendarViewMode.YEAR) {
            return null;
        }
        TemplateDecider<CalendarEvent<CalendarEvent<RECORD>>> templateDecider = this.activeViewMode == CalendarViewMode.MONTH ? this.monthViewTemplateDecider : this.dayViewTemplateDecider;
        Template templateFromDecider = templateDecider.getTemplate(record);
        Template defaultTemplate = this.activeViewMode == CalendarViewMode.MONTH ? this.monthViewTemplate : this.dayViewTemplate;
        Template template2 = template = templateFromDecider != null ? templateFromDecider : defaultTemplate;
        if (template != null && !this.templateIdsByTemplate.containsKey(template)) {
            String id = "" + this.templateIdCounter++;
            this.templateIdsByTemplate.put(template, id);
            this.queueCommandIfRendered(() -> new UiCalendar.RegisterTemplateCommand(this.getId(), id, template.createUiTemplate()));
        }
        return template;
    }

    public void setModel(CalendarModel<RECORD> model) {
        if (this.model != null) {
            this.unregisterModelEventListeners();
        }
        this.model = model;
        model.getOnCalendarDataChanged().addListener(this.onCalendarDataChangedListener);
        this.refreshEvents();
    }

    private void unregisterModelEventListeners() {
        this.model.getOnCalendarDataChanged().removeListener(this.onCalendarDataChangedListener);
    }

    @Override
    public UiComponent createUiComponent() {
        UiCalendar uiCalendar = new UiCalendar(this.getId());
        this.mapAbstractUiComponentProperties((UiComponent)uiCalendar);
        uiCalendar.setActiveViewMode(this.activeViewMode.toUiCalendarViewMode());
        uiCalendar.setDisplayedDate(this.displayedDate.atStartOfDay(this.getClientZoneId()).toInstant().toEpochMilli());
        uiCalendar.setShowHeader(this.showHeader);
        uiCalendar.setTableBorder(this.tableBorder);
        uiCalendar.setShowWeekNumbers(this.showWeekNumbers);
        uiCalendar.setBusinessHoursStart(this.businessHoursStart);
        uiCalendar.setBusinessHoursEnd(this.businessHoursEnd);
        uiCalendar.setFirstDayOfWeek(this.firstDayOfWeek != null ? UiWeekDay.valueOf((String)this.firstDayOfWeek.name()) : null);
        uiCalendar.setWorkingDays(this.workingDays.stream().map(workingDay -> UiWeekDay.valueOf((String)workingDay.name())).collect(Collectors.toList()));
        uiCalendar.setTableHeaderBackgroundColor(this.tableHeaderBackgroundColor != null ? UiUtil.createUiColor(this.tableHeaderBackgroundColor) : null);
        Instant queryStart = this.activeViewMode.getDisplayStart(this.displayedDate, this.firstDayOfWeek).atStartOfDay(this.getClientZoneId()).toInstant();
        Instant queryEnd = this.activeViewMode.getDisplayEnd(this.displayedDate, this.firstDayOfWeek).atStartOfDay(this.getClientZoneId()).toInstant();
        List<CalendarEvent<RECORD>> initialCalendarEvents = this.query(queryStart, queryEnd);
        CacheManipulationHandle<List<UiCalendarEventClientRecord>> cacheResponse = this.recordCache.replaceRecords(initialCalendarEvents);
        cacheResponse.commit();
        uiCalendar.setInitialData(cacheResponse.getResult());
        uiCalendar.setTemplates(this.templateIdsByTemplate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((Template)entry.getKey()).createUiTemplate())));
        return uiCalendar;
    }

    @Override
    protected void doDestroy() {
        if (this.model != null) {
            this.unregisterModelEventListeners();
        }
    }

    private List<CalendarEvent<RECORD>> query(Instant queryStart, Instant queryEnd) {
        List<CalendarEvent<RECORD>> events;
        if (this.model != null) {
            events = this.model.getEventsForInterval(queryStart, queryEnd);
            this.LOGGER.debug("Query: " + queryStart + " - " + queryEnd + " --> events:" + events.size());
        } else {
            events = Collections.emptyList();
        }
        return events;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_CALENDAR_EVENT_CLICKED: {
                UiCalendar.EventClickedEvent clickEvent = (UiCalendar.EventClickedEvent)event;
                CalendarEvent<RECORD> calendarEvent = this.recordCache.getRecordByClientId(clickEvent.getEventId());
                if (calendarEvent == null) break;
                this.onEventClicked.fire(new EventClickedEventData<RECORD>(calendarEvent, clickEvent.getIsDoubleClick()));
                break;
            }
            case UI_CALENDAR_EVENT_MOVED: {
                UiCalendar.EventMovedEvent eventMovedEvent = (UiCalendar.EventMovedEvent)event;
                CalendarEvent<RECORD> calendarEvent = this.recordCache.getRecordByClientId(eventMovedEvent.getEventId());
                if (calendarEvent == null) break;
                this.onEventMoved.fire(new EventMovedEventData<RECORD>(calendarEvent, Instant.ofEpochMilli(eventMovedEvent.getNewStart()), Instant.ofEpochMilli(eventMovedEvent.getNewEnd())));
                break;
            }
            case UI_CALENDAR_DAY_CLICKED: {
                UiCalendar.DayClickedEvent dayClickedEvent = (UiCalendar.DayClickedEvent)event;
                this.onDayClicked.fire(new DayClickedEventData(this.getClientZoneId(), Instant.ofEpochMilli(dayClickedEvent.getDate()), dayClickedEvent.getIsDoubleClick()));
                break;
            }
            case UI_CALENDAR_VIEW_CHANGED: {
                UiCalendar.ViewChangedEvent viewChangedEvent = (UiCalendar.ViewChangedEvent)event;
                this.displayedDate = this.epochMilliToUserLocalDate(viewChangedEvent);
                this.activeViewMode = CalendarViewMode.valueOf(viewChangedEvent.getViewMode().name());
                Instant queryStart = Instant.ofEpochMilli(viewChangedEvent.getDisplayedIntervalStart());
                Instant queryEnd = Instant.ofEpochMilli(viewChangedEvent.getDisplayedIntervalEnd());
                this.sendCalendarData(queryStart, queryEnd);
                this.onViewChanged.fire(new ViewChangedEventData(this.getClientZoneId(), this.activeViewMode, Instant.ofEpochMilli(viewChangedEvent.getMainIntervalStart()), Instant.ofEpochMilli(viewChangedEvent.getMainIntervalEnd()), Instant.ofEpochMilli(viewChangedEvent.getDisplayedIntervalStart()), Instant.ofEpochMilli(viewChangedEvent.getDisplayedIntervalEnd())));
                break;
            }
        }
    }

    private LocalDate epochMilliToUserLocalDate(UiCalendar.ViewChangedEvent viewChangedEvent) {
        return Instant.ofEpochMilli(viewChangedEvent.getMainIntervalStart()).atZone(this.getSessionContext().getTimeZone()).toLocalDate();
    }

    private void sendCalendarData(Instant queryStart, Instant queryEnd) {
        List<CalendarEvent<RECORD>> calendarEvents = this.query(queryStart, queryEnd);
        CacheManipulationHandle<List<UiCalendarEventClientRecord>> cacheResponse = this.recordCache.replaceRecords(calendarEvents);
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiCalendar.SetCalendarDataCommand(this.getId(), cacheResponse.getResult()), aVoid -> cacheResponse.commit());
        } else {
            cacheResponse.commit();
        }
    }

    public ToolbarButtonGroup createViewModesToolbarButtonGroup() {
        ToolbarButtonGroup group = new ToolbarButtonGroup();
        ToolbarButton yearViewButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.EVENT_NOTE, "Year", "12 Months Overview"));
        yearViewButton.onClick.addListener(toolbarButtonClickEvent -> this.setActiveViewMode(CalendarViewMode.YEAR));
        group.addButton(yearViewButton);
        ToolbarButton monthViewButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.DATE_RANGE, "Month", "Full Month View"));
        monthViewButton.onClick.addListener(toolbarButtonClickEvent -> this.setActiveViewMode(CalendarViewMode.MONTH));
        group.addButton(monthViewButton);
        ToolbarButton weekViewButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.VIEW_WEEK, "Week", "Week View"));
        weekViewButton.onClick.addListener(toolbarButtonClickEvent -> this.setActiveViewMode(CalendarViewMode.WEEK));
        group.addButton(weekViewButton);
        ToolbarButton dayViewButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.VIEW_DAY, "Day", "Single Day View"));
        dayViewButton.onClick.addListener(toolbarButtonClickEvent -> this.setActiveViewMode(CalendarViewMode.DAY));
        group.addButton(dayViewButton);
        return group;
    }

    public ToolbarButtonGroup createNavigationButtonGroup() {
        ToolbarButtonGroup group = new ToolbarButtonGroup();
        ToolbarButton forwardButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.NAVIGATE_BEFORE, "Previous", null));
        forwardButton.onClick.addListener(toolbarButtonClickEvent -> this.setDisplayedDate(this.activeViewMode.decrement(this.displayedDate)));
        group.addButton(forwardButton);
        ToolbarButton backButton = new ToolbarButton(BaseTemplate.TOOLBAR_BUTTON, new BaseTemplateRecord((Icon)MaterialIcon.NAVIGATE_NEXT, "Next", null));
        backButton.onClick.addListener(toolbarButtonClickEvent -> this.setDisplayedDate(this.activeViewMode.increment(this.displayedDate)));
        group.addButton(backButton);
        return group;
    }

    private ZoneId getClientZoneId() {
        return ZoneId.of(this.getSessionContext().getClientInfo().getTimeZone());
    }

    public void refreshEvents() {
        Instant queryStart = this.activeViewMode.getDisplayStart(this.displayedDate, this.firstDayOfWeek).atStartOfDay(this.getClientZoneId()).toInstant();
        Instant queryEnd = this.activeViewMode.getDisplayEnd(this.displayedDate, this.firstDayOfWeek).atStartOfDay(this.getClientZoneId()).toInstant();
        this.sendCalendarData(queryStart, queryEnd);
    }

    public CalendarModel getModel() {
        return this.model;
    }

    public CalendarViewMode getActiveViewMode() {
        return this.activeViewMode;
    }

    public void setActiveViewMode(CalendarViewMode activeViewMode) {
        this.activeViewMode = activeViewMode;
        this.queueCommandIfRendered(() -> new UiCalendar.SetViewModeCommand(this.getId(), activeViewMode.toUiCalendarViewMode()));
        this.refreshEvents();
    }

    public LocalDate getDisplayedDate() {
        return this.displayedDate;
    }

    public void setDisplayedDate(LocalDate displayedDate) {
        this.displayedDate = displayedDate;
        this.queueCommandIfRendered(() -> new UiCalendar.SetDisplayedDateCommand(this.getId(), displayedDate.atStartOfDay(this.getClientZoneId()).toInstant().toEpochMilli()));
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        this.reRenderIfRendered();
    }

    public boolean isTableBorder() {
        return this.tableBorder;
    }

    public void setTableBorder(boolean tableBorder) {
        this.tableBorder = tableBorder;
        this.reRenderIfRendered();
    }

    public boolean isShowWeekNumbers() {
        return this.showWeekNumbers;
    }

    public void setShowWeekNumbers(boolean showWeekNumbers) {
        this.showWeekNumbers = showWeekNumbers;
        this.reRenderIfRendered();
    }

    public int getBusinessHoursStart() {
        return this.businessHoursStart;
    }

    public void setBusinessHoursStart(int businessHoursStart) {
        this.businessHoursStart = businessHoursStart;
        this.reRenderIfRendered();
    }

    public int getBusinessHoursEnd() {
        return this.businessHoursEnd;
    }

    public void setBusinessHoursEnd(int businessHoursEnd) {
        this.businessHoursEnd = businessHoursEnd;
        this.reRenderIfRendered();
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        this.reRenderIfRendered();
    }

    public List<DayOfWeek> getWorkingDays() {
        return this.workingDays;
    }

    public void setWorkingDays(List<DayOfWeek> workingDays) {
        this.workingDays = workingDays;
        this.reRenderIfRendered();
    }

    public Color getTableHeaderBackgroundColor() {
        return this.tableHeaderBackgroundColor;
    }

    public void setTableHeaderBackgroundColor(Color tableHeaderBackgroundColor) {
        this.tableHeaderBackgroundColor = tableHeaderBackgroundColor;
        this.reRenderIfRendered();
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
    }

    public Color getDefaultBorderColor() {
        return this.defaultBorderColor;
    }

    public void setDefaultBorderColor(Color defaultBorderColor) {
        this.defaultBorderColor = defaultBorderColor;
    }

    public PropertyExtractor<RECORD> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public Template getDayViewTemplate() {
        return this.dayViewTemplate;
    }

    public void setDayViewTemplate(Template dayViewTemplate) {
        this.dayViewTemplate = dayViewTemplate;
    }

    public TemplateDecider<CalendarEvent<RECORD>> getDayViewTemplateDecider() {
        return this.dayViewTemplateDecider;
    }

    public void setDayViewTemplateDecider(TemplateDecider<CalendarEvent<RECORD>> dayViewTemplateDecider) {
        this.dayViewTemplateDecider = dayViewTemplateDecider;
    }

    public Template getMonthViewTemplate() {
        return this.monthViewTemplate;
    }

    public void setMonthViewTemplate(Template monthViewTemplate) {
        this.monthViewTemplate = monthViewTemplate;
    }

    public TemplateDecider<CalendarEvent<RECORD>> getMonthViewTemplateDecider() {
        return this.monthViewTemplateDecider;
    }

    public void setMonthViewTemplateDecider(TemplateDecider<CalendarEvent<RECORD>> monthViewTemplateDecider) {
        this.monthViewTemplateDecider = monthViewTemplateDecider;
    }
}

