/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.pageview;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiPageView;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.pageview.AbstractPageViewBlock;

public class PageView
extends AbstractComponent {
    private List<AbstractPageViewBlock> blocks = new ArrayList<AbstractPageViewBlock>();

    @Override
    protected void doDestroy() {
    }

    public UiPageView createUiComponent() {
        UiPageView uiPageView = new UiPageView(this.getId());
        this.mapAbstractUiComponentProperties((UiComponent)uiPageView);
        uiPageView.setBlocks(this.blocks.stream().map(block -> block.createUiBlock()).collect(Collectors.toList()));
        return uiPageView;
    }

    public void addBlock(AbstractPageViewBlock block) {
        this.blocks.add(block);
        this.queueCommandIfRendered(() -> new UiPageView.AddBlockCommand(this.getId(), block.createUiBlock(), false, null));
    }

    public void removeBlock(AbstractPageViewBlock block) {
        this.blocks.add(block);
        this.queueCommandIfRendered(() -> new UiPageView.RemoveBlockCommand(this.getId(), block.getClientId()));
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }
}

