/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.event.Event;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartDataPoint;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.TimeGraphZoomLevel;

public class SlidingWindowLineChartModel
implements TimeGraphModel {
    public final Event<Void> onTimeGraphDataChanged = new Event();
    private final int maxDataPoints;
    private final Map<String, List<LineChartDataPoint>> dataPointsByLineId = new HashMap<String, List<LineChartDataPoint>>();
    private long minX;
    private long maxX;

    public SlidingWindowLineChartModel(int maxDataPoints) {
        this.maxDataPoints = maxDataPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinePoint(String lineId, long xValue, double yValue, boolean fireModelDataChange) {
        LineChartDataPoint dataPoint = new LineChartDataPoint(xValue, yValue);
        SlidingWindowLineChartModel slidingWindowLineChartModel = this;
        synchronized (slidingWindowLineChartModel) {
            List lineChartDataPoints = this.dataPointsByLineId.computeIfAbsent(lineId, k -> new ArrayList());
            lineChartDataPoints.add(dataPoint);
            if (lineChartDataPoints.size() > this.maxDataPoints) {
                lineChartDataPoints.remove(0);
            }
        }
        this.updateMinMaxX();
        if (fireModelDataChange) {
            this.fireModelDataChange();
        }
    }

    public void fireModelDataChange() {
        this.onTimeGraphDataChanged.fire(null);
    }

    private void updateMinMaxX() {
        this.minX = this.dataPointsByLineId.values().stream().filter(points -> !points.isEmpty()).map(points -> (long)((LineChartDataPoint)points.get(0)).getX()).min(Long::compare).orElse(0L);
        this.maxX = this.dataPointsByLineId.values().stream().filter(points -> !points.isEmpty()).map(points -> (long)((LineChartDataPoint)points.get(points.size() - 1)).getX()).max(Long::compare).orElse(1L);
    }

    @Override
    public List<TimeGraphZoomLevel> getZoomLevels() {
        return Collections.singletonList(new TimeGraphZoomLevel(1L));
    }

    @Override
    public Event<Void> onDataChanged() {
        return this.onTimeGraphDataChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<LineChartDataPoint>> getDataPoints(Collection<String> lineIds, TimeGraphZoomLevel zoomLevel, Interval neededIntervalX) {
        SlidingWindowLineChartModel slidingWindowLineChartModel = this;
        synchronized (slidingWindowLineChartModel) {
            return this.dataPointsByLineId.entrySet().stream().filter(e -> lineIds.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.asList(((List)entry.getValue()).toArray(new LineChartDataPoint[0]))));
        }
    }

    @Override
    public Interval getDomainX(Collection<String> lineIds) {
        return new Interval(this.minX, this.maxX);
    }
}

