/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.webcontroller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.teamapps.common.format.Color;
import org.teamapps.data.value.SimpleDataRecord;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.application.Application;
import org.teamapps.ux.application.ApplicationBuilder;
import org.teamapps.ux.application.ApplicationDesktop;
import org.teamapps.ux.application.ApplicationGroup;
import org.teamapps.ux.application.ApplicationInfo;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.Animation;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.itemview.ItemGroup;
import org.teamapps.ux.component.itemview.ItemView;
import org.teamapps.ux.component.itemview.ItemViewItemBackgroundMode;
import org.teamapps.ux.component.login.LoginWindow;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.component.tabpanel.Tab;
import org.teamapps.ux.component.tabpanel.TabPanel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.workspacelayout.SimpleWorkSpaceLayout;
import org.teamapps.ux.component.workspacelayout.WorkSpaceLayoutView;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.StylingTheme;

public class ApplicationsController
implements ApplicationDesktop {
    private final RootPanel rootPanel;
    private final LoginWindow loginWindow;
    private final List<ApplicationBuilder> applicationBuilders;
    private ApplicationBuilder settingsBuilder;
    private List<String> preLaunchedApps;
    private Map<String, String> customAppBackgroundByAppName;
    private Map<String, StylingTheme> stylingThemeByAppName;
    private final SessionContext context;
    private TabPanel tabPanel;
    private Panel applicationsListingPanel;
    private Map<Tab, String> applicationNameByTab = new HashMap<Tab, String>();
    private String lastBackground;
    private Map<Tab, String> applicationNameByApplicationCustomTab = new HashMap<Tab, String>();

    public ApplicationsController(RootPanel rootPanel, LoginWindow loginWindow, List<ApplicationBuilder> applicationBuilders, ApplicationBuilder settingsBuilder, List<String> preLaunchedAppNames, Map<String, String> customAppBackgroundByAppName, Map<String, StylingTheme> stylingThemeByAppName, SessionContext context) {
        this.rootPanel = rootPanel;
        this.loginWindow = loginWindow;
        this.applicationBuilders = applicationBuilders;
        this.settingsBuilder = settingsBuilder;
        this.preLaunchedApps = preLaunchedAppNames;
        this.customAppBackgroundByAppName = customAppBackgroundByAppName;
        this.stylingThemeByAppName = stylingThemeByAppName;
        this.context = context;
    }

    public void createUi() {
        boolean isMobile = this.isMobile();
        ItemView applicationsListing = new ItemView();
        applicationsListing.setHeaderPropertyExtractor(SimpleDataRecord::getValue);
        applicationsListing.setGroupHeaderTemplate(BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        applicationsListing.setItemBackgroundMode(ItemViewItemBackgroundMode.LIGHT);
        applicationsListing.setHorizontalPadding(2);
        applicationsListing.setVerticalPadding(0);
        applicationsListing.setGroupSpacing(5);
        HashMap<String, ItemGroup> itemGroupsByApplicationGroupId = new HashMap<String, ItemGroup>();
        this.applicationsListingPanel = new Panel((Icon)MaterialIcon.APPS, "Anwendungen", applicationsListing);
        TextField appFilterField = new TextField();
        appFilterField.setShowClearButton(true);
        appFilterField.onTextInput.addListener(applicationsListing::setFilter);
        this.applicationsListingPanel.setRightHeaderField(appFilterField, (Icon)MaterialIcon.SEARCH, 100, 200);
        this.applicationsListingPanel.setAlwaysShowHeaderFieldIcons(true);
        HashMap<String, ApplicationBuilder> validBuilderMap = new HashMap<String, ApplicationBuilder>();
        for (ApplicationBuilder builder : this.applicationBuilders) {
            if (!builder.isApplicationAccessible()) continue;
            ApplicationInfo applicationInfo = builder.getApplicationInfo();
            validBuilderMap.put(applicationInfo.getName(), builder);
            ApplicationGroup applicationGroup = applicationInfo.getApplicationGroup();
            ItemGroup group = itemGroupsByApplicationGroupId.computeIfAbsent(applicationGroup.getId(), applicationGroupId -> {
                SimpleDataRecord headerData = new SimpleDataRecord("caption", applicationGroup.getCaption()).setValue("icon", applicationGroup.getIcon());
                ItemGroup<SimpleDataRecord, SimpleDataRecord> itemGroup = new ItemGroup<SimpleDataRecord, SimpleDataRecord>(headerData, BaseTemplate.APPLICATION_LISTING);
                itemGroup.setButtonWidth(isMobile ? 0.0f : 300.0f);
                applicationsListing.addGroup(itemGroup);
                itemGroup.setItemPropertyExtractor(SimpleDataRecord::getValue);
                return itemGroup;
            });
            group.addItem(new SimpleDataRecord("id", applicationInfo.getName()).setValue("icon", applicationInfo.getIcon()).setValue("caption", applicationInfo.getTitle()).setValue("description", applicationInfo.getDescription()));
        }
        if (isMobile) {
            SimpleDataRecord headerData = new SimpleDataRecord("caption", "Abmelden").setValue("icon", MaterialIcon.EXIT_TO_APP);
            ItemGroup<SimpleDataRecord, SimpleDataRecord> group = new ItemGroup<SimpleDataRecord, SimpleDataRecord>(headerData, BaseTemplate.APPLICATION_LISTING);
            group.setItemPropertyExtractor(SimpleDataRecord::getValue);
            group.setButtonWidth(0.0f);
            applicationsListing.addGroup(group);
            group.addItem(new SimpleDataRecord("id", "cmdLogout").setValue("icon", MaterialIcon.EXIT_TO_APP).setValue("caption", "Abmelden").setValue("description", "Vom System abmelden"));
        }
        this.tabPanel = new TabPanel();
        HashMap<String, Tab> tabsByApplicationItemId = new HashMap<String, Tab>();
        this.tabPanel.onTabClosed.addListener(tab -> tabsByApplicationItemId.values().remove(tab));
        applicationsListing.onItemClicked.addListener(eventData -> {
            SimpleDataRecord item = (SimpleDataRecord)eventData.getItem();
            String applicationName = (String)item.getValue("id");
            if (applicationName.equals("cmdLogout")) {
                this.loginWindow.getPasswordField().setValue(null);
                this.rootPanel.setContent(this.loginWindow.getElegantPanel(), Animation.FADE_ZOOM_GROW, 300L);
            } else {
                this.loadApplication(applicationName, validBuilderMap, this.applicationsListingPanel, tabsByApplicationItemId, this.tabPanel, this.rootPanel);
            }
        });
        this.tabPanel.onTabSelected.addListener(tab -> {
            String applicationName = this.applicationNameByTab.get(tab);
            if (applicationName == null) {
                applicationName = this.applicationNameByApplicationCustomTab.get(tab);
            }
            this.checkThemeAndBackground(applicationName);
        });
        if (isMobile) {
            this.rootPanel.setContent(this.applicationsListingPanel);
        } else {
            SimpleWorkSpaceLayout workSpaceLayout = new SimpleWorkSpaceLayout();
            workSpaceLayout.getCenterViewGroup().addView(new WorkSpaceLayoutView(workSpaceLayout, this.applicationsListingPanel, null, false, false));
            this.applicationsListingPanel.setBodyBackgroundColor(Color.WHITE.withAlpha(0.92f));
            Tab applicationsTab = new Tab((Icon)MaterialIcon.APPS, "Applications", workSpaceLayout);
            this.tabPanel.addTab(applicationsTab, true);
            if (this.settingsBuilder != null) {
                Tab settingsTab = new Tab((Icon)MaterialIcon.MORE_VERT, "Einstellungen", null, true);
                settingsTab.onSelected.addListener(aVoid -> settingsTab.setContent(this.settingsBuilder.createApplication(this).createUi()));
                settingsTab.setRightSide(true);
                this.tabPanel.addTab(settingsTab);
            }
            Tab logoutTab = new Tab((Icon)MaterialIcon.EXIT_TO_APP, "Logout", null, true);
            logoutTab.setRightSide(true);
            logoutTab.onSelected.addListener(aVoid -> {
                this.context.setBackgroundImage("login", 1000);
                this.rootPanel.setContent(this.loginWindow.getElegantPanel(), Animation.FADE_ZOOM_GROW, 300L);
            });
            this.tabPanel.addTab(logoutTab);
            this.rootPanel.setContent(this.tabPanel);
        }
        for (String preLaunchedApp : this.preLaunchedApps) {
            this.loadApplication(preLaunchedApp, validBuilderMap, this.applicationsListingPanel, tabsByApplicationItemId, this.tabPanel, this.rootPanel);
        }
    }

    private void loadApplication(String applicationName, Map<String, ApplicationBuilder> validBuilderMap, Panel applicationsListingPanel, Map<String, Tab> tabsByApplicationItemId, TabPanel tabPanel, RootPanel rootPanel) {
        ApplicationBuilder applicationBuilder = validBuilderMap.get(applicationName);
        if (!this.isMobile()) {
            Tab tab = tabsByApplicationItemId.computeIfAbsent(applicationName, name -> {
                Application application = applicationBuilder.createApplication(this);
                ApplicationInfo applicationInfo = applicationBuilder.getApplicationInfo();
                Tab newTab = new Tab(applicationInfo.getIcon(), applicationInfo.getTitle(), application.createUi());
                tabPanel.addTab(newTab, true);
                this.applicationNameByTab.put(newTab, applicationName);
                newTab.onClosed.addListener(aVoid -> this.applicationNameByTab.remove(newTab));
                return newTab.setCloseable(true);
            });
            tab.select();
        } else {
            Application application = applicationBuilder.createApplication(this);
            rootPanel.setContent(application.createUi());
        }
        this.checkThemeAndBackground(applicationName);
    }

    private void checkThemeAndBackground(String applicationName) {
        if (applicationName == null) {
            this.context.setBackgroundImage("default", 1000);
            this.context.getConfiguration().setTheme(StylingTheme.DEFAULT);
            this.context.setConfiguration(this.context.getConfiguration());
        } else {
            if (this.customAppBackgroundByAppName.containsKey(applicationName)) {
                this.context.setBackgroundImage(applicationName, 1000);
                this.lastBackground = applicationName;
            } else if (this.lastBackground != null && !this.lastBackground.equals("default")) {
                this.context.setBackgroundImage("default", 1000);
                this.lastBackground = "default";
            }
            this.context.getConfiguration().setTheme(this.stylingThemeByAppName.getOrDefault(applicationName, StylingTheme.DEFAULT));
            this.context.setConfiguration(this.context.getConfiguration());
        }
    }

    public void showApplication(ApplicationInfo applicationInfo, Application application) {
        if (!this.isMobile()) {
            Tab newTab = new Tab(applicationInfo.getIcon(), applicationInfo.getTitle(), application.createUi());
            this.tabPanel.addTab(newTab, true);
        } else {
            this.rootPanel.setContent(application.createUi());
        }
    }

    @Override
    public Component getApplicationsListingComponent() {
        return this.applicationsListingPanel;
    }

    @Override
    public void showTopLevelComponent(String originatingAppName, Icon icon, String title, Component component) {
        if (!this.isMobile()) {
            Tab newTab = new Tab(icon, title, component);
            newTab.setCloseable(true);
            this.applicationNameByApplicationCustomTab.put(newTab, originatingAppName);
            newTab.onClosed.addListener(aVoid -> this.applicationNameByApplicationCustomTab.remove(newTab));
            this.tabPanel.addTab(newTab, true);
        } else {
            this.rootPanel.setContent(component);
        }
    }

    @Override
    public void removeTopLevelComponent(Component component) {
        this.tabPanel.getTabs().stream().filter(tab -> Objects.equals(component, tab.getContent())).findAny().ifPresent(tabToRemove -> this.tabPanel.removeTab((Tab)tabToRemove));
    }

    public boolean isMobile() {
        return this.context.getClientInfo().isMobileDevice();
    }
}

