/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.teamapps.dto.AbstractUiDateTimeField;
import org.teamapps.dto.UiField;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.session.DateTimeFormatDescriptor;

public abstract class AbstractDateTimeField<VALUE>
extends AbstractField<VALUE> {
    private boolean showDropDownButton = true;
    private boolean favorPastDates = false;
    private ULocale locale = this.getSessionContext().getULocale();
    private DateTimeFormatDescriptor dateFormat = this.getSessionContext().getConfiguration().getDateFormat();
    private DateTimeFormatDescriptor timeFormat = this.getSessionContext().getConfiguration().getTimeFormat();

    protected void mapAbstractDateTimeFieldUiValues(AbstractUiDateTimeField uiField) {
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setShowDropDownButton(this.showDropDownButton);
        uiField.setFavorPastDates(this.favorPastDates);
        uiField.setLocale(this.locale.toLanguageTag());
        uiField.setDateFormat(this.dateFormat.toDateTimeFormatDescriptor());
        uiField.setTimeFormat(this.timeFormat.toDateTimeFormatDescriptor());
    }

    public boolean isShowDropDownButton() {
        return this.showDropDownButton;
    }

    public void setShowDropDownButton(boolean showDropDownButton) {
        this.showDropDownButton = showDropDownButton;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetShowDropDownButtonCommand(this.getId(), showDropDownButton));
    }

    public boolean isFavorPastDates() {
        return this.favorPastDates;
    }

    public void setFavorPastDates(boolean favorPastDates) {
        this.favorPastDates = favorPastDates;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetFavorPastDatesCommand(this.getId(), favorPastDates));
    }

    public Locale getLocale() {
        return this.locale.toLocale();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setULocale(ULocale locale) {
        this.locale = locale;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetLocaleAndFormatsCommand(this.getId(), locale.toLanguageTag(), this.dateFormat.toDateTimeFormatDescriptor(), this.timeFormat.toDateTimeFormatDescriptor()));
    }

    public DateTimeFormatDescriptor getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateTimeFormatDescriptor dateFormat) {
        this.dateFormat = dateFormat;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetLocaleAndFormatsCommand(this.getId(), this.locale.toLanguageTag(), dateFormat.toDateTimeFormatDescriptor(), this.timeFormat.toDateTimeFormatDescriptor()));
    }

    public DateTimeFormatDescriptor getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DateTimeFormatDescriptor timeFormat) {
        this.timeFormat = timeFormat;
        this.queueCommandIfRendered(() -> new AbstractUiDateTimeField.SetLocaleAndFormatsCommand(this.getId(), this.locale.toLanguageTag(), this.dateFormat.toDateTimeFormatDescriptor(), timeFormat.toDateTimeFormatDescriptor()));
    }
}

