/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.model.AbstractTreeModel;
import org.teamapps.ux.model.ComboBoxModel;

public class ListTreeModel<RECORD>
extends AbstractTreeModel<RECORD>
implements ComboBoxModel<RECORD> {
    private final List<RECORD> records = new ArrayList<RECORD>();
    private BiPredicate<RECORD, String> searchPredicate = (record, queryString) -> record.toString() != null && record.toString().toLowerCase().contains(queryString.toLowerCase());
    private Function<RECORD, TreeNodeInfo> treeNodeInfoFunction;

    public ListTreeModel(List<RECORD> records) {
        this(records, null);
    }

    public ListTreeModel(List<RECORD> records, BiPredicate<RECORD, String> searchPredicate) {
        this.records.addAll(records);
        if (searchPredicate != null) {
            this.searchPredicate = searchPredicate;
        }
    }

    public void setTreeNodeInfoFunction(Function<RECORD, TreeNodeInfo> treeNodeInfoFunction) {
        this.treeNodeInfoFunction = treeNodeInfoFunction;
    }

    @Override
    public TreeNodeInfo getTreeNodeInfo(RECORD record) {
        if (this.treeNodeInfoFunction != null) {
            return this.treeNodeInfoFunction.apply(record);
        }
        return super.getTreeNodeInfo(record);
    }

    @Override
    public List<RECORD> getRecords() {
        return this.records;
    }

    @Override
    public List<RECORD> getRecords(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return this.records;
        }
        return this.records.stream().filter(r -> this.searchPredicate.test(r, query)).collect(Collectors.toList());
    }

    public void setRecords(List<RECORD> records) {
        this.records.clear();
        this.records.addAll(records);
        this.onAllNodesChanged.fire();
    }

    public BiPredicate<RECORD, String> getSearchPredicate() {
        return this.searchPredicate;
    }

    public void setSearchPredicate(BiPredicate<RECORD, String> searchPredicate) {
        this.searchPredicate = searchPredicate;
    }
}

