/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.util;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiKeySequentialExecutor<K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiKeySequentialExecutor.class);
    private final AtomicReference<MinMaxAverageStats> delayStats = new AtomicReference<MinMaxAverageStats>(new MinMaxAverageStats());
    private final AtomicReference<MinMaxAverageStats> executionTimeStats = new AtomicReference<MinMaxAverageStats>(new MinMaxAverageStats());
    private final Map<K, SequentialExecutor> sequentialExecutors = new ConcurrentHashMap<K, SequentialExecutor>();
    private final ExecutorService pool;

    public MultiKeySequentialExecutor(int nThreads) {
        this(Executors.newFixedThreadPool(nThreads));
    }

    public MultiKeySequentialExecutor(ExecutorService executorService) {
        this.pool = executorService;
        ScheduledExecutorService statsLogExecutorService = Executors.newSingleThreadScheduledExecutor();
        statsLogExecutorService.scheduleAtFixedRate(() -> {
            MinMaxAverageStats delayStats = this.delayStats.getAndSet(new MinMaxAverageStats());
            MinMaxAverageStats executionTimeStats = this.executionTimeStats.getAndSet(new MinMaxAverageStats());
            if (delayStats.max > 3000L) {
                LOGGER.warn("Delays critical: min: {}, max: {}, avg: {}, count: {}", new Object[]{delayStats.getMin(), delayStats.getMax(), delayStats.getAvg(), delayStats.getCount()});
            }
            if (executionTimeStats.max > 1000L) {
                LOGGER.warn("Execution times critical: min: {}, max: {}, avg: {}, count: {}", new Object[]{executionTimeStats.getMin(), executionTimeStats.getMax(), executionTimeStats.getAvg(), executionTimeStats.getCount()});
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public CompletableFuture<Void> submit(K key, Runnable task) {
        return this.sequentialExecutors.computeIfAbsent(key, k -> new SequentialExecutor()).submit(task);
    }

    public <V> CompletableFuture<V> submit(K key, Supplier<V> task) {
        return this.sequentialExecutors.computeIfAbsent(key, k -> new SequentialExecutor()).submit(task);
    }

    public void closeForKey(K key) {
        this.sequentialExecutors.compute(key, (k, sequentialExecutor) -> {
            if (sequentialExecutor != null) {
                sequentialExecutor.close();
            }
            return null;
        });
    }

    public SequentialExecutor getExecutorForKey(K key) {
        return this.sequentialExecutors.get(key);
    }

    private static class MinMaxAverageStats {
        private final long min;
        private final long max;
        private final long total;
        private final long count;

        public MinMaxAverageStats() {
            this.min = Long.MAX_VALUE;
            this.max = 0L;
            this.total = 0L;
            this.count = 0L;
        }

        public MinMaxAverageStats(long min, long max, long total, long count) {
            this.min = min;
            this.max = max;
            this.total = total;
            this.count = count;
        }

        public MinMaxAverageStats push(long time) {
            return new MinMaxAverageStats(Math.min(time, this.min), Math.max(time, this.max), this.total + time, this.count + 1L);
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public long getAvg() {
            return this.total / this.count;
        }

        public long getCount() {
            return this.count;
        }
    }

    public class SequentialExecutor
    implements Executor {
        private CompletableFuture<?> lastFuture = CompletableFuture.completedFuture(null);
        private final AtomicInteger queueSize = new AtomicInteger(0);
        private boolean closed = false;

        @Override
        public void execute(Runnable command) {
            this.submit(command);
        }

        public synchronized CompletableFuture<Void> submit(Runnable runnable) {
            return this.submit(() -> {
                runnable.run();
                return null;
            });
        }

        public synchronized <V> CompletableFuture<V> submit(Supplier<V> task) {
            if (this.closed) {
                LOGGER.debug("SequentialExecutor already closed.");
                return CompletableFuture.failedFuture(new SequentialExecutorClosedException());
            }
            int queueSize = this.queueSize.incrementAndGet();
            LOGGER.debug("Queue size: {}", (Object)queueSize);
            if (queueSize > 500) {
                LOGGER.warn("Queue is very long: {}", (Object)queueSize);
            }
            long submitTime = System.currentTimeMillis();
            CompletionStage returnedFuture = this.lastFuture.thenApplyAsync(o -> {
                long executionStartTime = System.currentTimeMillis();
                long delay = executionStartTime - submitTime;
                MultiKeySequentialExecutor.this.delayStats.getAndUpdate(minMaxAverageStats -> minMaxAverageStats.push(delay));
                Object result = task.get();
                long executionTime = System.currentTimeMillis() - executionStartTime;
                MultiKeySequentialExecutor.this.executionTimeStats.getAndUpdate(minMaxAverageStats -> minMaxAverageStats.push(executionTime));
                this.queueSize.decrementAndGet();
                return result;
            }, (Executor)MultiKeySequentialExecutor.this.pool);
            this.lastFuture = ((CompletableFuture)returnedFuture).exceptionally(throwable -> {
                LOGGER.error("Error while executing: ", throwable);
                return null;
            });
            return returnedFuture;
        }

        private synchronized void close() {
            this.closed = true;
        }
    }

    public static class SequentialExecutorClosedException
    extends RuntimeException {
    }
}

