/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.teamapps.ux.i18n.TranslationProvider;

public class MapTranslationProvider
implements TranslationProvider {
    private Set<String> allKeys;
    private Map<Locale, Map<String, String>> translationsMap = new HashMap<Locale, Map<String, String>>();

    public MapTranslationProvider() {
        this.allKeys = new HashSet<String>();
    }

    public void addTranslation(Locale locale, String key, String value) {
        if (value == null) {
            return;
        }
        this.allKeys.add(key);
        this.translationsMap.computeIfAbsent(locale, loc -> new HashMap()).put(key, value);
    }

    @Override
    public List<Locale> getLanguages() {
        return new ArrayList<Locale>(this.translationsMap.keySet());
    }

    @Override
    public List<String> getKeys() {
        return new ArrayList<String>(this.allKeys);
    }

    @Override
    public String getTranslation(String key, Locale locale) {
        if (this.translationsMap.containsKey(locale)) {
            return this.translationsMap.get(locale).get(key);
        }
        return null;
    }
}

