/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class MultiResourceBundle
extends ResourceBundle {
    private List<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();

    public MultiResourceBundle() {
        this(new ResourceBundle[0]);
    }

    public MultiResourceBundle(ResourceBundle ... resourceBundles) {
        for (ResourceBundle resourceBundle : resourceBundles) {
            if (resourceBundle == null) continue;
            this.addResourceBundle(resourceBundle);
        }
    }

    public void addResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundles.add(resourceBundle);
    }

    @Override
    protected Object handleGetObject(String key) {
        for (ResourceBundle resourceBundle : this.resourceBundles) {
            String value = this.getString(key, resourceBundle);
            if (value == null) continue;
            return value;
        }
        return key;
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.resourceBundles.stream().flatMap(bundle -> bundle.keySet().stream()).collect(Collectors.toSet()));
    }

    private String getString(String key, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return null;
        }
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

