/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.task;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.task.ObservableProgress;
import org.teamapps.ux.task.Progress;
import org.teamapps.ux.task.function.ProgressReportingBiConsumer;
import org.teamapps.ux.task.function.ProgressReportingBiFunction;
import org.teamapps.ux.task.function.ProgressReportingConsumer;
import org.teamapps.ux.task.function.ProgressReportingFunction;
import org.teamapps.ux.task.function.ProgressReportingRunnable;
import org.teamapps.ux.task.function.ProgressReportingSupplier;

public class ProgressCompletableFuture<T>
extends CompletableFuture<T> {
    private static final boolean USE_COMMON_POOL = ForkJoinPool.getCommonPoolParallelism() > 1;
    public static final Executor ASYNC_POOL = USE_COMMON_POOL ? ForkJoinPool.commonPool() : r -> new Thread(r).start();
    private final Progress progress;

    public ProgressCompletableFuture() {
        this(new Progress());
    }

    public ProgressCompletableFuture(Progress progress) {
        this.progress = progress;
    }

    public ObservableProgress getProgress() {
        return this.progress;
    }

    @Override
    public boolean complete(T value) {
        this.progress.markCompleted();
        return super.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.progress.markFailed();
        return super.completeExceptionally(ex);
    }

    @Override
    public <U> ProgressCompletableFuture<U> newIncompleteFuture() {
        return new ProgressCompletableFuture<T>();
    }

    public static <U> ProgressCompletableFuture<U> supplyAsync(ProgressReportingSupplier<U> supplier) {
        return ProgressCompletableFuture.supplyAsync(supplier, ASYNC_POOL);
    }

    public static <U> ProgressCompletableFuture<U> supplyAsync(ProgressReportingSupplier<U> supplier, Executor executor) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        executor.execute(() -> {
            future.progress.start();
            try {
                Object result = supplier.get(future.progress);
                future.progress.markCompleted();
                future.complete(result);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static ProgressCompletableFuture<Void> runAsync(ProgressReportingRunnable runnable) {
        return ProgressCompletableFuture.runAsync(runnable, ASYNC_POOL);
    }

    public static ProgressCompletableFuture<Void> runAsync(ProgressReportingRunnable runnable, Executor executor) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        executor.execute(ProgressCompletableFuture.runWrapped(runnable, future));
        return future;
    }

    public static <U> ProgressCompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return ProgressCompletableFuture.supplyAsync(supplier, ASYNC_POOL);
    }

    public static <U> ProgressCompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        executor.execute(() -> {
            future.progress.start();
            try {
                Object result = supplier.get();
                future.progress.markCompleted();
                future.complete(result);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static ProgressCompletableFuture<Void> runAsync(Runnable runnable) {
        return ProgressCompletableFuture.runAsync(runnable, ASYNC_POOL);
    }

    public static ProgressCompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        executor.execute(ProgressCompletableFuture.runWrapped(runnable, future));
        return future;
    }

    public <U> ProgressCompletableFuture<U> thenApplyWithSessionContext(Function<? super T, ? extends U> fn) {
        SessionContext sessionContext = CurrentSessionContext.get();
        return this.thenApply((T t) -> {
            Object[] result = new Object[1];
            sessionContext.runWithContext(() -> {
                result[0] = fn.apply(t);
            });
            return result[0];
        });
    }

    public ProgressCompletableFuture<Void> thenAcceptWithCurrentSessionContext(Consumer<? super T> action) {
        SessionContext sessionContext = CurrentSessionContext.get();
        return this.thenAccept((T t) -> sessionContext.runWithContext(() -> action.accept(t)));
    }

    public ProgressCompletableFuture<Void> thenRunWithCurrentSessionContext(Runnable action) {
        SessionContext sessionContext = CurrentSessionContext.get();
        return this.thenRun(() -> sessionContext.runWithContext(action));
    }

    public ProgressCompletableFuture<T> whenCompleteWithCurrentSessionContext(BiConsumer<? super T, ? super Throwable> action) {
        SessionContext sessionContext = CurrentSessionContext.get();
        return this.whenComplete((T t, U throwable) -> sessionContext.runWithContext(() -> action.accept((Object)t, (Throwable)throwable)));
    }

    public <U> ProgressCompletableFuture<U> handleWithCurrentSessionContext(BiFunction<? super T, Throwable, ? extends U> fn) {
        SessionContext sessionContext = CurrentSessionContext.get();
        return this.handle((T t, U throwable) -> {
            Object[] result = new Object[1];
            sessionContext.runWithContext(() -> {
                result[0] = fn.apply((Object)t, (Throwable)throwable);
            });
            return result[0];
        });
    }

    public ProgressCompletableFuture<T> exceptionallyWithCurrentSessionContext(Function<Throwable, ? extends T> fn) {
        SessionContext sessionContext = CurrentSessionContext.get();
        return this.exceptionally((T throwable) -> {
            Object[] result = new Object[1];
            sessionContext.runWithContext(() -> {
                result[0] = fn.apply((Throwable)throwable);
            });
            return result[0];
        });
    }

    @Override
    public <U> ProgressCompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.thenApply(this.applyWrapped(fn, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public <U> ProgressCompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.thenApplyAsync(this.applyWrapped(fn, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public <U> ProgressCompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.thenApplyAsync(this.applyWrapped(fn, future), executor)).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private <U> Function<T, Object> applyWrapped(Function<? super T, ? extends U> fn, ProgressCompletableFuture<U> future) {
        return t -> {
            future.progress.start();
            try {
                Object result = fn.apply(t);
                future.progress.markCompleted();
                future.complete(result);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
            return null;
        };
    }

    public ProgressCompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenAccept((Consumer)this.acceptWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    public ProgressCompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenAcceptAsync((Consumer)this.acceptWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    public ProgressCompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenAcceptAsync((Consumer)this.acceptWrapped(action, future), executor)).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private Consumer<T> acceptWrapped(Consumer<? super T> action, ProgressCompletableFuture<Void> future) {
        return t -> {
            future.progress.start();
            try {
                action.accept(t);
                future.progress.markCompleted();
                future.complete(null);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
        };
    }

    @Override
    public ProgressCompletableFuture<Void> thenRun(Runnable action) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenRun(ProgressCompletableFuture.runWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public ProgressCompletableFuture<Void> thenRunAsync(Runnable action) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenRunAsync(ProgressCompletableFuture.runWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public ProgressCompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenRunAsync(ProgressCompletableFuture.runWrapped(action, future), executor)).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private static Runnable runWrapped(Runnable action, ProgressCompletableFuture<Void> future) {
        return () -> {
            future.progress.start();
            try {
                action.run();
                future.progress.markCompleted();
                future.complete(null);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
        };
    }

    @Override
    public ProgressCompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.whenComplete(this.whenCompleteWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public ProgressCompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.whenCompleteAsync(this.whenCompleteWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public ProgressCompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.whenCompleteAsync(this.whenCompleteWrapped(action, future), executor)).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private BiConsumer<T, Throwable> whenCompleteWrapped(BiConsumer<? super T, ? super Throwable> action, ProgressCompletableFuture<T> future) {
        return (t, throwable) -> {
            future.progress.start();
            try {
                action.accept((Object)t, (Throwable)throwable);
                future.progress.markCompleted();
            }
            catch (Exception e) {
                future.progress.markFailed();
            }
            finally {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete(t);
                }
            }
        };
    }

    @Override
    public <U> ProgressCompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        ProgressCompletableFuture<T> future = new ProgressCompletableFuture<T>();
        super.handle((BiFunction)this.handleWrapped(fn, future));
        return future;
    }

    @Override
    public <U> ProgressCompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        ProgressCompletableFuture<T> future = new ProgressCompletableFuture<T>();
        super.handleAsync((BiFunction)this.handleWrapped(fn, future));
        return future;
    }

    @Override
    public <U> ProgressCompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        ProgressCompletableFuture<T> future = new ProgressCompletableFuture<T>();
        super.handleAsync((BiFunction)this.handleWrapped(fn, future), executor);
        return future;
    }

    private <U> BiFunction<T, Throwable, U> handleWrapped(BiFunction<? super T, Throwable, ? extends U> fn, ProgressCompletableFuture<U> future) {
        return (t, throwable) -> {
            future.progress.start();
            try {
                Object result = fn.apply((Object)t, (Throwable)throwable);
                future.progress.markCompleted();
                future.complete(result);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
            return null;
        };
    }

    @Override
    public ProgressCompletableFuture<T> toCompletableFuture() {
        return (ProgressCompletableFuture)super.toCompletableFuture();
    }

    @Override
    public ProgressCompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        super.exceptionally((T throwable) -> {
            future.progress.start();
            try {
                Object result = fn.apply((Throwable)throwable);
                future.progress.markCompleted();
                future.complete(result);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
            return null;
        });
        return future;
    }

    @Override
    public ProgressCompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        return (ProgressCompletableFuture)super.completeAsync(this.completeWrapped(supplier), executor);
    }

    @Override
    public ProgressCompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        return (ProgressCompletableFuture)super.completeAsync(this.completeWrapped(supplier));
    }

    private Supplier<T> completeWrapped(Supplier<? extends T> supplier) {
        return () -> {
            this.progress.start();
            try {
                Object result = supplier.get();
                this.progress.markCompleted();
                this.complete(result);
            }
            catch (Exception e) {
                this.progress.markFailed();
                this.completeExceptionally(e);
            }
            return null;
        };
    }

    @Override
    public ProgressCompletableFuture<T> orTimeout(long timeout, TimeUnit unit) {
        return (ProgressCompletableFuture)super.orTimeout(timeout, unit);
    }

    @Override
    public ProgressCompletableFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        return (ProgressCompletableFuture)super.completeOnTimeout(value, timeout, unit);
    }

    @Override
    public <U> ProgressCompletableFuture<U> thenApply(ProgressReportingFunction<? super T, ? extends U> fn) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.thenApply(this.applyWrapped(fn, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public <U> ProgressCompletableFuture<U> thenApplyAsync(ProgressReportingFunction<? super T, ? extends U> fn) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.thenApplyAsync(this.applyWrapped(fn, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public <U> ProgressCompletableFuture<U> thenApplyAsync(ProgressReportingFunction<? super T, ? extends U> fn, Executor executor) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.thenApplyAsync(this.applyWrapped(fn, future), executor)).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private <U> Function<T, Object> applyWrapped(ProgressReportingFunction<? super T, ? extends U> fn, ProgressCompletableFuture<U> future) {
        return t -> {
            future.progress.start();
            try {
                Object result = fn.apply(t, future.progress);
                future.progress.markCompleted();
                future.complete(result);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
            return null;
        };
    }

    public ProgressCompletableFuture<Void> thenAccept(ProgressReportingConsumer<? super T> action) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenAccept((Consumer)this.acceptWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    public ProgressCompletableFuture<Void> thenAcceptAsync(ProgressReportingConsumer<? super T> action) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenAcceptAsync((Consumer)this.acceptWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    public ProgressCompletableFuture<Void> thenAcceptAsync(ProgressReportingConsumer<? super T> action, Executor executor) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenAcceptAsync((Consumer)this.acceptWrapped(action, future), executor)).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private Consumer<T> acceptWrapped(ProgressReportingConsumer<? super T> action, ProgressCompletableFuture<Void> future) {
        return t -> {
            future.progress.start();
            try {
                action.accept(t, future.progress);
                future.progress.markCompleted();
                future.complete(null);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
        };
    }

    public ProgressCompletableFuture<Void> thenRun(ProgressReportingRunnable action) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenRun(ProgressCompletableFuture.runWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    public ProgressCompletableFuture<Void> thenRunAsync(ProgressReportingRunnable action) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenRunAsync(ProgressCompletableFuture.runWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    public ProgressCompletableFuture<Void> thenRunAsync(ProgressReportingRunnable action, Executor executor) {
        ProgressCompletableFuture<Void> future = new ProgressCompletableFuture<Void>();
        ((CompletableFuture)super.thenRunAsync(ProgressCompletableFuture.runWrapped(action, future), executor)).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private static Runnable runWrapped(ProgressReportingRunnable action, ProgressCompletableFuture<Void> future) {
        return () -> {
            future.progress.start();
            try {
                action.run(future.progress);
                future.progress.markCompleted();
                future.complete(null);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
        };
    }

    @Override
    public ProgressCompletableFuture<T> whenComplete(ProgressReportingBiConsumer<? super T, ? super Throwable> action) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.whenComplete(this.whenCompleteWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public ProgressCompletableFuture<T> whenCompleteAsync(ProgressReportingBiConsumer<? super T, ? super Throwable> action) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.whenCompleteAsync(this.whenCompleteWrapped(action, future))).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    @Override
    public ProgressCompletableFuture<T> whenCompleteAsync(ProgressReportingBiConsumer<? super T, ? super Throwable> action, Executor executor) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        ((CompletableFuture)super.whenCompleteAsync(this.whenCompleteWrapped(action, future), executor)).exceptionally((T throwable) -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private BiConsumer<T, Throwable> whenCompleteWrapped(ProgressReportingBiConsumer<? super T, ? super Throwable> action, ProgressCompletableFuture<T> future) {
        return (t, throwable) -> {
            future.progress.start();
            try {
                action.accept((Object)t, (Throwable)throwable, future.progress);
                future.progress.markCompleted();
            }
            catch (Exception e) {
                future.progress.markFailed();
            }
            finally {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete(t);
                }
            }
        };
    }

    @Override
    public <U> ProgressCompletableFuture<U> handle(ProgressReportingBiFunction<? super T, Throwable, ? extends U> fn) {
        ProgressCompletableFuture<T> future = new ProgressCompletableFuture<T>();
        super.handle((BiFunction)this.handleWrapped(fn, future));
        return future;
    }

    @Override
    public <U> ProgressCompletableFuture<U> handleAsync(ProgressReportingBiFunction<? super T, Throwable, ? extends U> fn) {
        ProgressCompletableFuture<T> future = new ProgressCompletableFuture<T>();
        super.handleAsync((BiFunction)this.handleWrapped(fn, future));
        return future;
    }

    @Override
    public <U> ProgressCompletableFuture<U> handleAsync(ProgressReportingBiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        ProgressCompletableFuture<T> future = new ProgressCompletableFuture<T>();
        super.handleAsync((BiFunction)this.handleWrapped(fn, future), executor);
        return future;
    }

    private <U> BiFunction<T, Throwable, U> handleWrapped(ProgressReportingBiFunction<? super T, Throwable, ? extends U> fn, ProgressCompletableFuture<U> future) {
        return (t, throwable) -> {
            future.progress.start();
            try {
                Object result = fn.apply((Object)t, (Throwable)throwable, future.progress);
                future.progress.markCompleted();
                future.complete(result);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
            return null;
        };
    }

    @Override
    public ProgressCompletableFuture<T> exceptionally(ProgressReportingFunction<Throwable, ? extends T> fn) {
        ProgressCompletableFuture future = new ProgressCompletableFuture();
        super.exceptionally((T throwable) -> {
            future.progress.start();
            try {
                Object result = fn.apply((Throwable)throwable, future.progress);
                future.progress.markCompleted();
                future.complete(result);
            }
            catch (Exception e) {
                future.progress.markFailed();
                future.completeExceptionally(e);
            }
            return null;
        });
        return future;
    }

    @Override
    public ProgressCompletableFuture<T> completeAsync(ProgressReportingSupplier<? extends T> supplier, Executor executor) {
        return (ProgressCompletableFuture)super.completeAsync(this.completeWrapped(supplier), executor);
    }

    @Override
    public ProgressCompletableFuture<T> completeAsync(ProgressReportingSupplier<? extends T> supplier) {
        return (ProgressCompletableFuture)super.completeAsync(this.completeWrapped(supplier));
    }

    private Supplier<T> completeWrapped(ProgressReportingSupplier<? extends T> supplier) {
        return () -> {
            this.progress.start();
            try {
                Object result = supplier.get(this.progress);
                this.progress.markCompleted();
                this.complete(result);
            }
            catch (Exception e) {
                this.progress.markFailed();
                this.completeExceptionally(e);
            }
            return null;
        };
    }
}

