/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.schema.TableOption;

public class TableConfig {
    public static final int CHECKPOINTS = 1;
    public static final int VERSIONING = 2;
    public static final int HIERARCHY = 3;
    public static final int TRACK_CREATION = 4;
    public static final int TRACK_MODIFICATION = 5;
    public static final int KEEP_DELETED = 6;
    private final BitSet bitSet = new BitSet();

    public static IndexType getIndexType(int id) {
        switch (id) {
            case 1: 
            case 2: {
                return IndexType.LONG;
            }
        }
        return IndexType.INT;
    }

    public static TableConfig parse(String tableDefinition) {
        if (!tableDefinition.contains("(")) {
            return new TableConfig();
        }
        String line = tableDefinition.substring(tableDefinition.lastIndexOf(40) + 1, tableDefinition.lastIndexOf(41));
        String[] parts = line.split(", ");
        ArrayList<TableOption> tableOptions = new ArrayList<TableOption>();
        for (String part : parts) {
            tableOptions.add(TableOption.valueOf(part.trim()));
        }
        return TableConfig.create(tableOptions);
    }

    public static TableConfig create(List<TableOption> tableOptions) {
        TableConfig config = new TableConfig();
        for (TableOption option : tableOptions) {
            config.setOption(option.getId());
        }
        return config;
    }

    public static TableConfig create(TableOption ... options) {
        TableConfig config = new TableConfig();
        for (TableOption option : options) {
            config.setOption(option.getId());
        }
        return config;
    }

    public List<TableOption> getTableOptions() {
        ArrayList<TableOption> tableOptions = new ArrayList<TableOption>();
        int id = this.bitSet.nextSetBit(0);
        while (id >= 0) {
            TableOption tableOption = TableOption.getById(id);
            if (tableOption != null) {
                tableOptions.add(tableOption);
            }
            id = this.bitSet.nextSetBit(id + 1);
        }
        return tableOptions;
    }

    public String writeConfig() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (TableOption option : this.getTableOptions()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(option.name());
        }
        if (sb.length() == 1) {
            return "";
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean isCheckpoints() {
        return this.getOption(1);
    }

    public boolean isVersioning() {
        return this.getOption(2);
    }

    public boolean isHierarchy() {
        return this.getOption(3);
    }

    public boolean trackCreation() {
        return this.getOption(4);
    }

    public boolean trackModification() {
        return this.getOption(5);
    }

    public boolean keepDeleted() {
        return this.getOption(6);
    }

    public void setOption(int id) {
        if (id > 30) {
            return;
        }
        this.bitSet.set(id);
    }

    public boolean getOption(int id) {
        return this.bitSet.get(id);
    }

    public IntStream getColumns() {
        return this.bitSet.stream();
    }

    public String toString() {
        return this.bitSet.toString();
    }
}

