/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster.message;

import java.io.IOException;
import org.teamapps.universaldb.cluster.message.ClusterMessage;
import org.teamapps.universaldb.cluster.network.MessageType;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.transaction.TransactionPacket;
import org.teamapps.universaldb.transaction.TransactionRequest;

public class ResolvedTransactionRequest
implements ClusterMessage {
    private final TransactionRequest transactionRequest;
    private final byte[] data;

    public ResolvedTransactionRequest(TransactionRequest transactionRequest) throws IOException {
        this.transactionRequest = transactionRequest;
        this.data = transactionRequest.getPacket().writePacketBytes();
    }

    public ResolvedTransactionRequest(byte[] data, DataBaseMapper dataBaseMapper) throws IOException {
        this.data = data;
        TransactionPacket transactionPacket = new TransactionPacket(data);
        this.transactionRequest = new TransactionRequest(transactionPacket, dataBaseMapper);
    }

    public TransactionRequest getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    public MessageType getType() {
        return MessageType.RESOLVED_TRANSACTION;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

