/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.binary.BinaryIndex;
import org.teamapps.universaldb.index.file.FileFilter;
import org.teamapps.universaldb.index.file.FileMetaData;
import org.teamapps.universaldb.index.file.FileStore;
import org.teamapps.universaldb.index.file.FileUtil;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.transaction.DataType;

public class FileIndex
extends AbstractIndex<FileValue, FileFilter> {
    private final TextIndex uuidIndex;
    private final TextIndex hashIndex;
    private final LongIndex sizeIndex;
    private final BinaryIndex metaDataIndex;
    private final FullTextIndexingOptions fullTextIndexingOptions;
    private final CollectionTextSearchIndex fileDataIndex;
    private final FileStore fileStore;
    private final String filePath;

    public FileIndex(String name, TableIndex table, FullTextIndexingOptions fullTextIndexingOptions, CollectionTextSearchIndex collectionSearchIndex, FileStore fileStore) {
        super(name, table, fullTextIndexingOptions);
        this.uuidIndex = new TextIndex(name + "-file-uuid", table, false);
        this.hashIndex = new TextIndex(name + "-file-hash", table, false);
        this.sizeIndex = new LongIndex(name + "-file-size", table);
        this.fileDataIndex = fullTextIndexingOptions.isIndex() ? new CollectionTextSearchIndex(this.getPath(), name) : null;
        this.metaDataIndex = fullTextIndexingOptions.isIndex() ? new BinaryIndex(name, table) : null;
        this.fullTextIndexingOptions = fullTextIndexingOptions;
        this.filePath = this.getFQN().toLowerCase().replace('.', '/');
        this.fileStore = fileStore;
    }

    @Override
    public IndexType getType() {
        return IndexType.FILE;
    }

    @Override
    public FileValue getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, FileValue value) {
        this.setValue(id, value);
    }

    public FileValue getValue(int id) {
        String uuid = this.uuidIndex.getValue(id);
        if (uuid != null) {
            byte[] value;
            String hash = this.hashIndex.getValue(id);
            long size = this.sizeIndex.getValue(id);
            FileValue fileValue = new FileValue(uuid, hash, size);
            if (this.fullTextIndexingOptions.isIndex() && (value = this.metaDataIndex.getValue(id)) != null) {
                try {
                    FileMetaData metaData = new FileMetaData(value);
                    fileValue.setMetaData(metaData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Supplier<File> fileSupplier = this.fileStore.getFileSupplier(this.filePath, uuid, hash);
            fileValue.setFileSupplier(fileSupplier);
            return fileValue;
        }
        return null;
    }

    public void setValue(int id, FileValue value) {
        String uuid = this.uuidIndex.getValue(id);
        if (value == null) {
            if (uuid != null) {
                this.uuidIndex.setValue(id, null);
                this.hashIndex.setValue(id, null);
                this.sizeIndex.setValue(id, 0L);
                if (this.fileDataIndex != null) {
                    this.fileDataIndex.setRecordValues(id, Collections.emptyList(), true);
                    this.metaDataIndex.setValue(id, null);
                }
            }
        } else {
            boolean update = uuid != null;
            this.uuidIndex.setValue(id, value.getUuid());
            this.hashIndex.setValue(id, value.getHash());
            this.sizeIndex.setValue(id, value.getSize());
            if (this.fileDataIndex != null && value.getMetaData() != null) {
                this.fileDataIndex.setRecordValues(id, value.getMetaData().getFullTextIndexData(), update);
                this.metaDataIndex.setValue(id, value.getMetaData().getMetaDataBytes());
            }
        }
    }

    public FileValue storeFile(File file) {
        if (file == null) {
            return null;
        }
        FileValue fileValue = new FileValue(file);
        return this.storeFile(fileValue);
    }

    public FileValue storeFile(FileValue fileValue) {
        if (fileValue == null || fileValue.retrieveFile() == null) {
            return null;
        }
        if (this.fullTextIndexingOptions.isIndex()) {
            FileMetaData metaData = FileUtil.parseFileMetaData(fileValue.retrieveFile());
            fileValue.setMetaData(metaData);
        }
        this.fileStore.setFile(this.filePath, fileValue.getUuid(), fileValue.getHash(), fileValue.retrieveFile());
        fileValue.setFileSupplier(this.fileStore.getFileSupplier(this.filePath, fileValue.getUuid(), fileValue.getHash()));
        return fileValue;
    }

    public void removeStoredFile(int id) {
        String uuid = this.uuidIndex.getValue(id);
        if (uuid != null) {
            this.fileStore.removeFile(this.filePath, uuid);
        }
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, null);
    }

    @Override
    public void writeTransactionValue(FileValue value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.FILE_VALUE.getId());
        value.writeValues(dataOutputStream);
    }

    @Override
    public FileValue readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return new FileValue(dataInputStream);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending) {
        return sortEntries;
    }

    @Override
    public BitSet filter(BitSet records, FileFilter fileFilter) {
        switch (fileFilter.getFilterType()) {
            case FULL_TEXT_FILTER: {
                return this.filterFullText(records, fileFilter);
            }
            case SIZE_EQUALS: {
                return this.sizeIndex.filterEquals(records, fileFilter.getSize());
            }
            case SIZE_NOT_EQUALS: {
                return this.sizeIndex.filterNotEquals(records, fileFilter.getSize());
            }
            case SIZE_GREATER: {
                return this.sizeIndex.filterGreater(records, fileFilter.getSize());
            }
            case SIZE_SMALLER: {
                return this.sizeIndex.filterSmaller(records, fileFilter.getSize());
            }
            case SIZE_BETWEEN: {
                return this.sizeIndex.filterBetween(records, fileFilter.getSize(), fileFilter.getSize2());
            }
        }
        return null;
    }

    public BitSet filterFullText(BitSet records, FileFilter fileFilter) {
        if (this.fileDataIndex != null) {
            return this.fileDataIndex.filter(records, fileFilter.getTextFilters(), false);
        }
        return new BitSet();
    }

    @Override
    public void close() {
        if (this.fileDataIndex != null) {
            this.fileDataIndex.commit(true);
        }
        this.uuidIndex.close();
        this.hashIndex.close();
        this.sizeIndex.close();
    }

    @Override
    public void drop() {
        if (this.fileDataIndex != null) {
            this.fileDataIndex.drop();
        }
        this.uuidIndex.drop();
        this.hashIndex.drop();
        this.sizeIndex.drop();
    }
}

