/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.file.FileMetaDataEntry;
import org.teamapps.universaldb.index.text.TextValue;
import org.teamapps.universaldb.util.DataStreamUtil;

public class FileMetaData {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_MIME_TYPE = "mime";
    public static final String FIELD_HASH = "hash";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELD_META = "language";
    private final String name;
    private final long size;
    private String mimeType;
    private String hash;
    private final List<FileMetaDataEntry> entries = new ArrayList<FileMetaDataEntry>();
    private String textContent;
    private String language;

    public FileMetaData(String name, long size) {
        this.name = name;
        this.size = size;
    }

    public FileMetaData(byte[] data) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(data)));
    }

    public FileMetaData(DataInputStream dataInputStream) throws IOException {
        this.name = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.size = dataInputStream.readLong();
        this.mimeType = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.hash = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        int len = dataInputStream.readInt();
        for (int i = 0; i < len; ++i) {
            String property = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
            String value = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
            this.entries.add(new FileMetaDataEntry(property, value));
        }
        this.textContent = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.language = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
    }

    public byte[] getMetaDataBytes() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            DataStreamUtil.writeStringWithLengthHeader(dos, this.name);
            dos.writeLong(this.size);
            DataStreamUtil.writeStringWithLengthHeader(dos, this.mimeType);
            DataStreamUtil.writeStringWithLengthHeader(dos, this.hash);
            dos.writeInt(this.entries.size());
            for (FileMetaDataEntry entry : this.entries) {
                DataStreamUtil.writeStringWithLengthHeader(dos, entry.getProperty());
                DataStreamUtil.writeStringWithLengthHeader(dos, entry.getValue());
            }
            DataStreamUtil.writeStringWithLengthHeader(dos, this.textContent);
            DataStreamUtil.writeStringWithLengthHeader(dos, this.language);
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMetaDataProperty(String propertyName) {
        return this.entries.stream().filter(entry -> entry.getProperty().equals(propertyName)).map(entry -> entry.getValue()).findAny().orElse(null);
    }

    public List<String> getPropertyNames() {
        return this.entries.stream().map(entry -> entry.getProperty()).collect(Collectors.toList());
    }

    public List<TextValue> getFullTextIndexData() {
        ArrayList<TextValue> values = new ArrayList<TextValue>();
        values.add(new TextValue(FIELD_NAME, this.name));
        values.add(new TextValue(FIELD_MIME_TYPE, this.mimeType));
        values.add(new TextValue(FIELD_HASH, this.hash));
        values.add(new TextValue(FIELD_CONTENT, this.textContent));
        values.add(new TextValue("language", this.language));
        StringBuilder sb = new StringBuilder();
        for (FileMetaDataEntry metaDataEntry : this.entries) {
            sb.append(metaDataEntry.getValue()).append(" ");
        }
        values.add(new TextValue("language", sb.toString()));
        return values;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void addMetaDataEntry(String property, String value) {
        if (property == null || property.isBlank() || value == null || value.isBlank()) {
            return;
        }
        this.entries.add(new FileMetaDataEntry(property, value));
    }

    public List<FileMetaDataEntry> getEntries() {
        return this.entries;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("file name:").append(this.name).append("\n");
        sb.append("size:").append(this.size).append("\n");
        sb.append("type:").append(this.mimeType).append("\n");
        sb.append("hash:").append(this.hash).append("\n");
        sb.append("language:").append(this.language).append("\n");
        if (this.textContent != null) {
            String value = this.textContent.length() > 1000 ? this.textContent.substring(0, 1000) : this.textContent;
            value = value.trim().replace('\n', ' ').replace('\r', ' ');
            sb.append(value).append("\n");
        }
        for (FileMetaDataEntry entry : this.entries) {
            sb.append("\t").append(entry.getProperty()).append(":").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

