/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Supplier;
import org.teamapps.universaldb.index.file.FileMetaData;
import org.teamapps.universaldb.index.file.FileUtil;
import org.teamapps.universaldb.util.DataStreamUtil;

public class FileValue {
    private final String uuid;
    private final String hash;
    private final long size;
    private FileMetaData metaData;
    private Supplier<File> fileSupplier;

    public FileValue(File file) {
        this.uuid = "ta" + UUID.randomUUID().toString().replace("-", "").toLowerCase();
        this.hash = FileUtil.createFileHash(file);
        this.size = file.length();
        this.fileSupplier = () -> file;
    }

    public FileValue(String uuid, String hash, long size) {
        this.uuid = uuid;
        this.hash = hash;
        this.size = size;
    }

    public FileValue(DataInputStream dataInputStream) throws IOException {
        this.uuid = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.hash = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.size = dataInputStream.readLong();
        byte[] bytes = DataStreamUtil.readByteArrayWithLengthHeader(dataInputStream);
        if (bytes != null && bytes.length > 0) {
            this.metaData = new FileMetaData(bytes);
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getHash() {
        return this.hash;
    }

    public long getSize() {
        return this.size;
    }

    public FileMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(FileMetaData metaData) {
        this.metaData = metaData;
    }

    public Supplier<File> getFileSupplier() {
        return this.fileSupplier;
    }

    public void setFileSupplier(Supplier<File> fileSupplier) {
        this.fileSupplier = fileSupplier;
    }

    public File retrieveFile() {
        if (this.fileSupplier == null) {
            return null;
        }
        return this.fileSupplier.get();
    }

    public void writeValues(DataOutputStream dataOutputStream) throws IOException {
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, this.uuid);
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, this.hash);
        dataOutputStream.writeLong(this.size);
        if (this.metaData == null) {
            dataOutputStream.writeInt(0);
        } else {
            byte[] metaDataBytes = this.metaData.getMetaDataBytes();
            DataStreamUtil.writeByteArrayWithLengthHeader(dataOutputStream, metaDataBytes);
        }
    }
}

